/******************************************************************************
*
* FILE:          Msg_FeatureConfig.h
*
* SW-COMPONENT:  Configuration
*
* PROJECT: 		 G3G
*
* DESCRIPTION:   Configuration file for FC_Messaging component
*
* AUTHOR   :     usman sheik
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#ifndef MSG_FEATURECONFIG_H
#define MSG_FEATURECONFIG_H

#include "../ConnectivityConfig.h"

#define MINIMUM_DEVICE_HANDLE          2
#define MAXIMUM_DEVICE_HANDLE          11
#define MAXIMUM_DEVICE_SUPPORT         12

#define MAX_MAP_RETRY                  3

//CMG3G-11704- PSA - Support for SMS/MMS with 1000 characters,Max short msg length in characters. CRQ-CMG3G-9132 :Support for SMS/MMS with more than 160 characters,
//CRQ 158546 -Chery - Max SMS length in characters to be 1000 characters
#define FC_MESSAGING_SHORTMESSAGE_MAX_LEN_CHAR_COUNT 1000   // Max short msg length in characters

#define SEND_MESSAGE_CONTENT_MAX_LENGTH 160                 // Max msg content length in characters for sending messages
#define CONVERSATION_LIST_SUBJECT_LENGTH 160                // Max subject length in characters for conversation list

#ifdef VARIANT_S_FTR_ENABLE_PSA_FEATURES
   #define EMAIL_SUPPORT   //Email only supported in PSA
   #define DEFAULT_PREDEFINEDMESSAGES_PSA // Default Predefined messages for PSA
#elif defined(VARIANT_S_FTR_ENABLE_AIVI_FEATURES)
   #define DEFAULT_PREDEFINEDMESSAGES_AIVI // Default Predefined messages for AIVI
   #undef MAXIMUM_DEVICE_HANDLE
   #define MAXIMUM_DEVICE_HANDLE          7
   #undef MAXIMUM_DEVICE_SUPPORT
   #define MAXIMUM_DEVICE_SUPPORT         8
#elif defined(VARIANT_S_FTR_ENABLE_INF4CV_FEATURES) || defined(VARIANT_S_FTR_ENABLE_SMART_FEATURES)
   #define DEFAULT_PREDEFINEDMESSAGES_AIVI // Default Predefined messages for AIVI
#endif

#ifdef VARIANT_S_FTR_ENABLE_READ_MESSAGE_ALOUD
   #define READ_MESSAGE_ALOUD_SUPPORT
#endif

#define FC_MSG_DB_OLD_DIR_PATH "/opt/bosch"
#define FC_MSG_DB_DIR_PATH "/var/opt/bosch/dynamic/connectivity/connectivity_mw"
#define FC_MSG_DB_FILE_NAME "messaging.db"
#define FC_MSG_DB_USER_NAME "aid_messaging"
#define FC_MSG_DB_GROUP_NAME "aid_messaging"
#define FC_MSG_DB_RECREATE_TRIGGER_FILE_NAME  "msg.db.recreate.trigger"
#define FC_MSG_DB_JOURNAL_FILE_NAME           "messaging.db-journal"
#define FC_MSG_DB_CONNECTION_NAME "fc_messaging_database_connection"
#define FILE_ALERT_NEW_MSG "/var/opt/bosch/static/connectivity/tones/AlertToneMessageIn.mp3"
#define FILE_ALERT_WRN_MSG "/var/opt/bosch/static/connectivity/tones/AlertToneMsgMemoryFull.mp3"
#define FILE_ALERT_PLAY "/var/opt/bosch/static/connectivity/tones/AlertToneMessageRec.mp3"
#define FC_MSG_DB_DIR_PATH1 "/var/opt/bosch/dynamic/connectivity/connectivity_mw/"

#endif   //MSG_FEATURECONFIG_H
