/******************************************************************************
*
* FILE:          ConnectivityConfig.h
*
* SW-COMPONENT:  Configuration
*
* PROJECT: 		 G3G
*
* DESCRIPTION:   Common Configuration file for Connectivity components
*
* AUTHOR   :     usman sheik
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef CONNECTIVITYCONFIG_H
#define CONNECTIVITYCONFIG_H

/* define common features - project independent
 * For the new startup procedure according to G3G
 */
#define CONNECTIVITY_PROCESS_STARTUP_GEN3
#define CONNECTIVITY_SIRI
#define DEFAULT_TIMEOUT_VAL_DBUS_CALL 300000
#define CONNECT_PBAP_MAP_VIA_BM_APPL  //PBAP/MAP connect via BMAPP - 308977
#define RETRY_PBAP_MAP_VIA_BM_APPL    //PBAP/MAP retry via BMAPP - 308977

/*
 * ARL_AUDIO defined other than GM projects. Since GM using AV manager - ARL_AUDIO.
 * SIRI feature enabled for GM  - CONNECTIVITY_SIRI.
 * Enhanced call control is is supported only in GM
 * Diagnosis is need for all the projects - CONNECTIVITY_DIAGNOSIS_GM.
 * This feature switch will be removed once all the components removed from its coding.
 * New Start up procedure is enabled for G3G projects( JAC and PSA ) and not for GM
 */

#if defined(VARIANT_S_FTR_ENABLE_G3G_FEATURES) //G3G
#define  BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL

#elif defined (VARIANT_S_FTR_ENABLE_AIVI_FEATURES) || defined (VARIANT_S_FTR_ENABLE_INF4CV_FEATURES) || defined (VARIANT_S_FTR_ENABLE_SMART_FEATURES) //AIVI , INF4CV & SMART
#define  BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL

#elif defined (VARIANT_S_FTR_ENABLE_PSA_FEATURES)//PSA
#define  BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL

#elif defined(VARIANT_S_FTR_ENABLE_JAC_FEATURES)//JAC
#define  BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL
#undef CONNECTIVITY_SIRI
#undef CONNECT_PBAP_MAP_VIA_BM_APPL  //PBAP/MAP connect via BMAPP - 308977
#undef RETRY_PBAP_MAP_VIA_BM_APPL    //PBAP/MAP retry via BMAPP - 308977

#elif defined(VARIANT_S_FTR_ENABLE_CAF_FEATURES) //CAF
#define  BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL
#undef CONNECTIVITY_SIRI

#endif

#endif // CONNECTIVITYCONFIG_H
