/**
 * @file PmApp_Trace.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PhoneCallManager trace classes
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup Phone Call Manager
 */
#ifndef PmAppTrace_h
#define PmAppTrace_h

#define _DONT_DEFINE_UNDERSCORE_AS_COMMA_ //this is required to use the boost library
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

// Definition of PM Application trace classes

#define PM_APP_OFFSET 0x26

#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

// trace classes based on TR_COMP_CONNECTIVITY (256 * 59) = 0x3B00 - see mc_trace.h
#define TR_CLASS_PM_APPLICATION_ASF    TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x00
#define TR_CLASS_PM_APPLICATION        TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x01
#define TR_CLASS_PM_SERVICE            TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x02
//Trace classes 0x3B29 - 0x3B2B is used in IAP_BT_PLUGIN, hence the same is not defined in PhoneCallManager
#define TR_CLASS_PM_CORE               TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x06
#define TR_CLASS_BT_STACK_WRAPPER      TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x07
#define TR_CLASS_PM_AUDIO_MANAGER      TR_COMP_CONNECTIVITY + PM_APP_OFFSET + 0x08

#else

#define TR_CLASS_PM_APPLICATION_ASF    "PM_APP_ASF"
#define TR_CLASS_PM_APPLICATION        "PM_APP"
#define TR_CLASS_PM_SERVICE            "PM_SERVICE"
#define TR_CLASS_PM_CORE               "PM_CORE"
#define TR_CLASS_BT_STACK_WRAPPER      "BT_STACK_WRAPPER"
#define TR_CLASS_PM_AUDIO_MANAGER      "PM_AUDIO_MGR"

#endif //VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

#endif //PmAppTrace_h
