/**
 * @file LcmCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the LcmCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for LcmCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#include "LcmCallBackIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/clienthandlers", LcmCallBackIf, Info);

LcmCallBackIf::LcmCallBackIf()
{
   LOG_INFO("LcmCallBackIf::LcmCallBackIf() entered");
}

LcmCallBackIf::~LcmCallBackIf()
{
}

void LcmCallBackIf::setLcmFiProxy(LcmDBusFiProxy lcmFiProxy)
{
   LOG_INFO("LcmCallBackIf::setLcmFiProxy() entered");
   _lcmFiProxy = lcmFiProxy;
}

void LcmCallBackIf::onSubStatesError(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< SubStatesError >& error)
{
   LOG_INFO("LcmCallBackIf::onSubStatesError() entered");

   // TODO: Manipulation and Logical handling of errors need to be done in the upcoming releases.
   // Once those changes are done, logs printing the Error message and name shall be removed
   // since they are already printed from the generated code of ASF.

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      LOG_INFO("Error handling needs to be done");

      LOG_ERROR("Error Message: %s", error->getMessage().c_str());
      LOG_ERROR("Error Name: %s", error->getName().c_str());
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onSubStatesUpdate(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< SubStatesUpdate >& update)
{
   LOG_INFO("LcmCallBackIf::onSubStatesUpdate() Entered");

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      TSubStates subStates = update->getSubStates();
      uint32 subState = subStates.getSubState();
      LOG_INFO("subState : %u", subState);
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onSystemStateError(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< SystemStateError >& error)
{
   LOG_INFO("LcmCallBackIf::onSystemStateError() entered");

   // TODO: Manipulation and Logical handling of errors need to be done in the upcoming releases.
   // Once those changes are done, logs printing the Error message and name shall be removed
   // since they are already printed from the generated code of ASF.

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      LOG_INFO("Error handling needs to be done");

      LOG_ERROR("Error Message: %s", error->getMessage().c_str());
      LOG_ERROR("Error Name: %s", error->getName().c_str());
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onSystemStateUpdate(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< SystemStateUpdate >& update)
{
   // TODO: All the Instrumentation code is added for testing purpose only, will be removed soon.
   LOG_INFO("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered");

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      T_SPM_e32_SYSTEM_STATES systemState = update->getSystemState();
      LOG_INFO("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() : systemState - %d", systemState);

      switch(systemState)
      {
         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STANDBY:
         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_RESTRICTED:
         {
            LOG_INFO ("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered::: STANDBY");
         }
         break;

         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_OFF:
         {
            LOG_INFO ("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered::: OFF");
         }
         break;

         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_ON:
         {
            LOG_INFO ("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered::: ON");
         }
         break;

         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_PREPARE_SHUTDOWN:
         {
            LOG_INFO ("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered::: PREPARE_SHUTDOWN");
         }
         break;

         case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SHUTDOWN:
         {
            LOG_INFO ("Instrumentation purpose LcmCallBackIf::onSystemStateUpdate() entered::: SHUTDOWN");
         }
         break;

         default:
         {
            LOG_INFO("Instrumentation purpose Default state");
         }
      }
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onOnOffTriggerError(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< OnOffTriggerError >& error)
{
   LOG_INFO("LcmCallBackIf::onOnOffTriggerError() entered");

   // TODO: Manipulation and Logical handling of errors need to be done in the upcoming releases.
   // Once those changes are done, logs printing the Error message and name shall be removed
   // since they are already printed from the generated code of ASF.

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      LOG_INFO("Error handling needs to be done");

      LOG_ERROR("Error Message: %s", error->getMessage().c_str());
      LOG_ERROR("Error Name: %s", error->getName().c_str());
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onOnOffTriggerResponse(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< OnOffTriggerResponse >& response)
{
   LOG_INFO("LcmCallBackIf::onOnOffTriggerResponse() entered");

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      int32 resOut = response->getS32ResOut();
      LOG_INFO("resOut : %d", resOut);
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onBluetoothStateError(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< BluetoothStateError >& error)
{
   LOG_INFO("LcmCallBackIf::onBluetoothStateError() entered");

   // TODO: Manipulation and Logical handling of errors need to be done in the upcoming releases.
   // Once those changes are done, logs printing the Error message and name shall be removed
   // since they are already printed from the generated code of ASF.

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      LOG_INFO("Error handling needs to be done");

      LOG_ERROR("Error Message: %s", error->getMessage().c_str());
      LOG_ERROR("Error Name: %s", error->getName().c_str());
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void LcmCallBackIf::onBluetoothStateUpdate(const LcmDBusFiProxy& proxy,
      const ::boost::shared_ptr< BluetoothStateUpdate >& update)
{
   LOG_INFO("LcmCallBackIf::onBluetoothStateUpdate() entered");

   if ((_lcmFiProxy.get()) && (proxy == _lcmFiProxy))
   {
      T_SPM_e32_BT_STATE bluetoothState = update->getBluetoothState();
      LOG_INFO("bluetoothState : %u", bluetoothState);
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

} // namespace pmapp
} // namespace bosch
} // namespace com
