/**
 * @file LcmCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the LcmCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for LcmCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef LcmCallBackIf_h
#define LcmCallBackIf_h

#include "asf/core/Logger.h"

#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceProxy.h"
#include "ILcmCallBackIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class LcmCallBackIf final : public ILcmCallBackIf
{
public:
   /**
    * Constructor of LcmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   LcmCallBackIf();

   /**
    * Destructor of LcmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~LcmCallBackIf();

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setLcmFiProxy(LcmDBusFiProxy lcmFiProxy) override;

protected:
   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSubStatesError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SubStatesError >& error) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSubStatesUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SubStatesUpdate >& update) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSystemStateError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SystemStateError >& error) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * TBD: Persistent memory handling during the system Ignition on/off and Accessory on/off need to be done
    * based on either the Bluetooth State or System State.
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSystemStateUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SystemStateUpdate >& update) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOnOffTriggerError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< OnOffTriggerError >& error) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOnOffTriggerResponse(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< OnOffTriggerResponse >& response) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onBluetoothStateError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< BluetoothStateError >& error) override;

   /**
    * Member function Overridden from ILcmCallBackIf class
    *
    * TBD: Persistent memory handling during the system Ignition on/off and Accessory on/off need to be done
    * based on either the Bluetooth State or System State.
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onBluetoothStateUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< BluetoothStateUpdate >& update) override;

private:
   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //LcmCallBackIf_h
