/**
 * @file PmAppClientHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmAppClientHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details PM - ASF client relevant instances are instantiated here !
 *          This file defines the PmAppClientHandler class and its member functions
 *
 * @ingroup IpcWrapper
 */

#include "PmAppClientHandler.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmAppClientHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

namespace com
{
namespace bosch
{
namespace pmapp
{

PmAppClientHandler::PmAppClientHandler()
{
   ETG_TRACE_USR4(("PmAppClientHandler::PmAppClientHandler() entered"));

   _lcmRequestIf = new LcmRequestIf;
   _lcmCallBackIf = new LcmCallBackIf;
   _lcmRequestIf->setLcmCallBackIf(_lcmCallBackIf);

   _bmAppRequestIf = new BmAppRequestIf;
   _bmAppCallBackIf = new BmAppCallBackIf;
   _bmAppRequestIf->setBmAppCallBackIf(_bmAppCallBackIf);

   _phoneBookRequestIf = new PhoneBookRequestIf;
   _phoneBookCallBackIf = new PhoneBookCallBackIf;
   _phoneBookRequestIf->setPhoneBookCallBackIf(_phoneBookCallBackIf);

   _mediaPlayerRequestIf = new MediaPlayerRequestIf;
   _mediaPlayerCallBackIf = new MediaPlayerCallBackIf;
   _mediaPlayerRequestIf->setMediaPlayerCallBackIf(_mediaPlayerCallBackIf);
   
   _diagSystemSettings = new DiagSystemSettings;
}

PmAppClientHandler::~PmAppClientHandler()
{
   ETG_TRACE_USR4(("PmAppClientHandler::~PmAppClientHandler() entered"));

   if(_lcmRequestIf)
   {
      delete _lcmRequestIf;
      _lcmRequestIf = nullptr;
   }
   if(_lcmCallBackIf)
   {
      delete _lcmCallBackIf;
      _lcmCallBackIf = nullptr;
   }

   if(_diagSystemSettings)
   {
	  delete _diagSystemSettings;
	  _diagSystemSettings = nullptr;
   }

   if(_bmAppRequestIf)
   {
      delete _bmAppRequestIf;
      _bmAppRequestIf = nullptr;
   }
   if(_bmAppCallBackIf)
   {
      delete _bmAppCallBackIf;
      _bmAppCallBackIf = nullptr;
   }

   if(_phoneBookRequestIf)
   {
      delete _phoneBookRequestIf;
      _phoneBookRequestIf = nullptr;
   }
   if(_phoneBookCallBackIf)
   {
      delete _phoneBookCallBackIf;
      _phoneBookCallBackIf = nullptr;
   }
}

IBmAppCallBackIf* PmAppClientHandler::getBmAppCallBackIf()
{
   ETG_TRACE_USR4(("PmAppClientHandler::getBmAppCallBackIf() entered"));
   return _bmAppCallBackIf;
}

} // namespace pmapp
} // namespace bosch
} // namespace com
