/**
 * @file QueryRequestedContact.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the QueryRequestedContact class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef QueryRequestedContact_h
#define QueryRequestedContact_h

#include "PmInterfaceTypesInternal.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class QueryRequestedContact
{
public:
   /**
    * Constructor of QueryRequestedContact class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueryRequestedContact();

   /**
    * Parameterized Constructor of QueryRequestedContact class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueryRequestedContact(const pmcore::BdAddress& deviceAddress, const pmcore::TelephoneNumber& telephonenumber);

   /**
    * Copy Constructor of QueryRequestedContact class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueryRequestedContact(const QueryRequestedContact& other);

   /**
    * Destructor of QueryRequestedContact class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~QueryRequestedContact();

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(QueryRequestedContact& first, QueryRequestedContact& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   QueryRequestedContact& operator=(QueryRequestedContact other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const QueryRequestedContact& rhs) const;

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const QueryRequestedContact& rhs) const;

   pmcore::BdAddress       _deviceAddress;   // Device address
   pmcore::TelephoneNumber _telephoneNumber; // Telephone number for which the search is requested.
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // QueryRequestedContact_h
