/**
 * @file QueryRequestedContact.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the QueryRequestedContact class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "QueryRequestedContact.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/QueryRequestedContact.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#endif
#endif

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

QueryRequestedContact::QueryRequestedContact() : _deviceAddress(""), _telephoneNumber("")
{
}

QueryRequestedContact::QueryRequestedContact(const BdAddress& deviceAddress, const TelephoneNumber& telephoneNumber) :
      _deviceAddress(deviceAddress), _telephoneNumber(telephoneNumber)
{
}

QueryRequestedContact::QueryRequestedContact(const QueryRequestedContact& other) :
      _deviceAddress(other._deviceAddress), _telephoneNumber(other._telephoneNumber)
{
}

QueryRequestedContact::~QueryRequestedContact()
{
}

void swap(QueryRequestedContact& first, QueryRequestedContact& second)
{
   using std::swap;

   swap(first._deviceAddress, second._deviceAddress);
   swap(first._telephoneNumber, second._telephoneNumber);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
QueryRequestedContact& QueryRequestedContact::operator=(QueryRequestedContact other)
{
   swap(*this, other);

   return *this;
}

bool QueryRequestedContact::operator==(const QueryRequestedContact& rhs) const
{
   return ((this->_deviceAddress == rhs._deviceAddress)
         && (this->_telephoneNumber == rhs._telephoneNumber));
}

bool QueryRequestedContact::operator!=(const QueryRequestedContact& rhs) const
{
   return (!(operator==(rhs)));
}

} // namespace pmapp
} // namespace bosch
} // namespace com
