/**
 * @file QueriedContactInfo.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the QueriedContactInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef QueriedContactInfo_h
#define QueriedContactInfo_h

#include "IpcMsgTypes.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class QueriedContactInfo
{
public:
   /**
    * Constructor of QueriedContactInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueriedContactInfo();

   /**
    * Parameterized Constructor of QueriedContactInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueriedContactInfo(const pmcore::FirstName& firstName, const pmcore::LastName& lastName,
         const ContactHandle& contactHandle);

   /**
    * Copy Constructor of QueriedContactInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   QueriedContactInfo(const QueriedContactInfo& other);

   /**
    * Destructor of QueriedContactInfo class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~QueriedContactInfo();

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(QueriedContactInfo& first, QueriedContactInfo& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   QueriedContactInfo& operator=(QueriedContactInfo other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const QueriedContactInfo& rhs) const;

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const QueriedContactInfo& rhs) const;

   pmcore::FirstName _firstName;
   pmcore::LastName _lastName;
   ContactHandle _contactHandle;
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // QueriedContactInfo_h
