/**
 * @file DialRequestInfo.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DialRequestInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "DialRequestInfo.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DialRequestInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#endif
#endif

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

DialRequestInfo::DialRequestInfo() : _deviceAddress(""), _telephoneNumber(""),
      _act(PM_DEFAULT_ACT)
{
}

DialRequestInfo::DialRequestInfo(const BdAddress& deviceAddress,
      const TelephoneNumber& telephoneNumber, const ActType act) :
      _deviceAddress(deviceAddress), _telephoneNumber(telephoneNumber), _act(act)
{
}

DialRequestInfo::DialRequestInfo(const DialRequestInfo& other) :
      _deviceAddress(other._deviceAddress), _telephoneNumber(other._telephoneNumber), _act(other._act)
{
}

DialRequestInfo::~DialRequestInfo()
{
}

void swap(DialRequestInfo& first, DialRequestInfo& second)
{
   using std::swap;

   swap(first._deviceAddress, second._deviceAddress);
   swap(first._telephoneNumber, second._telephoneNumber);
   swap(first._act, second._act);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
DialRequestInfo& DialRequestInfo::operator=(DialRequestInfo other)
{
   swap(*this, other);

   return *this;
}

bool DialRequestInfo::operator==(const DialRequestInfo& rhs) const
{
   return ((this->_deviceAddress == rhs._deviceAddress)
         && (this->_telephoneNumber == rhs._telephoneNumber)
         && (this->_act == rhs._act));
}

bool DialRequestInfo::operator!=(const DialRequestInfo& rhs) const
{
   return (!(operator==(rhs)));
}

bool DialRequestInfo::operator<(const DialRequestInfo& rhs) const
{
    return (_act < rhs._act);
}

} // namespace pmapp
} // namespace bosch
} // namespace com
