/**
 * @file DeviceDetails.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MsgTypes between IpcWrapper and CPP layer
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef DeviceDetails_h
#define DeviceDetails_h

#include "DeviceIdentification.h"
#include "CallsReport.h"
#include "PmCoreIfTypes.h"
#include <vector>
#include <string>

namespace com
{
namespace bosch
{
namespace pmapp
{

/**
 * enum- Device Connection Status
 */
enum DeviceConnectionStatus {
   DEVICE_CONNECTIONSTATUS_DEFAULT = 0u,
   DEVICE_NOT_HFP_CONNECTED,
   DEVICE_HFP_CONNECTED,
   DEVICE_HFP_DISCONNECTED
};

class DeviceDetails
{
public:
   /**
    * Constructor of DeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceDetails();

   /**
    * Destructor of DeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~DeviceDetails();

   /**
    * Parameterized constructor of DeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceDetails(const pmcore::BdAddress& deviceAddress, const pmcore::DeviceHandle deviceHandle,
         const pmcore::DeviceName& deviceName, const DeviceConnectionStatus deviceConnectionStatus,
         const pmcore::DeviceIdentification& deviceIdentification,
         const pmcore::DeviceRole deviceRole = pmcore::DEVICEROLE_DEFAULT,
         const CallsReport& callsReport = CallsReport());

   /**
    * Copy constructor of DeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceDetails(const DeviceDetails& other);

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(DeviceDetails& first, DeviceDetails& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   DeviceDetails& operator=(DeviceDetails other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const DeviceDetails& rhs) const;

   pmcore::BdAddress _deviceAddress;
   pmcore::DeviceHandle _deviceHandle;
   pmcore::DeviceName _deviceName;
   DeviceConnectionStatus _deviceConnectionStatus;
   pmcore::DeviceIdentification _deviceIdentification;
   pmcore::DeviceRole _deviceRole;
   CallsReport _callsReport;

   void printDeviceIdentity();
};

typedef std::vector<DeviceDetails> DeviceDetailsList;

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // #define DeviceDetails_h
