/**
 * @file CallsReport.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallsReport class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CallsReport.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CallsReport.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#endif
#endif

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

CallsReport::CallsReport() : _multiparty(false), _callAttributesList()
{
}

CallsReport::CallsReport(const Multiparty multiparty, const CallAttributesList& callAttributesList) :
      _multiparty(multiparty), _callAttributesList(callAttributesList)
{
}

CallsReport::CallsReport(const CallsReport& other) :
      _multiparty(other._multiparty), _callAttributesList(other._callAttributesList)
{
}

CallsReport::~CallsReport()
{
}

void swap(CallsReport& first, CallsReport& second)
{
   using std::swap;

   swap(first._multiparty, second._multiparty);
   swap(first._callAttributesList, second._callAttributesList);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
CallsReport& CallsReport::operator=(CallsReport other)
{
   swap(*this, other);

   return *this;
}

bool CallsReport::operator==(const CallsReport& rhs) const
{
   return ((this->_multiparty == rhs._multiparty)
         && (this->_callAttributesList == rhs._callAttributesList));
}

bool CallsReport::operator!=(const CallsReport& rhs) const
{
   return (!(operator==(rhs)));
}

void CallsReport::printCallsReport()
{
   ETG_TRACE_USR4(("printCallsReport"));

   ETG_TRACE_USR4(("_multiparty: %u", _multiparty));

   for (std::pair<std::string, CallAttributes> callAttributesIter : _callAttributesList)
   {
      ETG_TRACE_USR4(("_Telephone number: %s", callAttributesIter.first.c_str()));
      ETG_TRACE_USR4(("_instance: %u", callAttributesIter.second._instance));
      ETG_TRACE_USR4(("_state: %s", callAttributesIter.second._state.c_str()));
      ETG_TRACE_USR4(("_durationHr: %u", callAttributesIter.second._durationHr));
      ETG_TRACE_USR4(("_durationMin: %u", callAttributesIter.second._durationMin));
      ETG_TRACE_USR4(("_durationSec: %u", callAttributesIter.second._durationSec));
      ETG_TRACE_USR4(("_mode: %u", callAttributesIter.second._mode));
      ETG_TRACE_USR4(("_type: %u", callAttributesIter.second._type));
      ETG_TRACE_USR4(("_direction: %u", callAttributesIter.second._direction));
      ETG_TRACE_USR4(("_firstName: %s", callAttributesIter.second._firstName.c_str()));
      ETG_TRACE_USR4(("_lastName: %s", callAttributesIter.second._lastName.c_str()));
      ETG_TRACE_USR4(("_contactHandle: %u", callAttributesIter.second._contactHandle));
   }
}

} // namespace pmapp
} // namespace bosch
} // namespace com
