/**
 * @file CallAttributes.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallAttributes class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CallAttributes.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CallAttributes.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_SERVICE
#endif
#endif

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

CallAttributes::CallAttributes() :
               _instance(CALL_INSTANCE_DEFAULT),
               _state(""),
               _durationHr(CALL_DURATION_DEFAULT),
               _durationMin(CALL_DURATION_DEFAULT),
               _durationSec(CALL_DURATION_DEFAULT),
               _mode(CALL_MODE_UNKNOWN),
               _type(NUMBER_TYPE_UNKNOWN),
               _direction(CALL_DIRECTION_UNKNOWN),
               _firstName(""), _lastName(""),
               _contactHandle(CONTACT_HANDLE_DEFAULT),
               _isContactProvidedByClient(false)
{
}

CallAttributes::CallAttributes(const CallAttributes& other) :
               _instance(other._instance),
               _state(other._state),
               _durationHr(other._durationHr),
               _durationMin(other._durationMin),
               _durationSec(other._durationSec),
               _mode(other._mode),
               _type(other._type),
               _direction(other._direction),
               _firstName(other._firstName),
               _lastName(other._lastName),
               _contactHandle(other._contactHandle),
               _isContactProvidedByClient(other._isContactProvidedByClient)
{
}

CallAttributes::~CallAttributes()
{
}

void swap(CallAttributes& first, CallAttributes& second)
{
   using std::swap;

   swap(first._instance, second._instance);
   swap(first._state, second._state);
   swap(first._durationHr, second._durationHr);
   swap(first._durationMin, second._durationMin);
   swap(first._durationSec, second._durationSec);
   swap(first._mode, second._mode);
   swap(first._type, second._type);
   swap(first._direction, second._direction);
   swap(first._firstName, second._firstName);
   swap(first._lastName, second._lastName);
   swap(first._contactHandle, second._contactHandle);
   swap(first._isContactProvidedByClient, second._isContactProvidedByClient);
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
CallAttributes& CallAttributes::operator=(CallAttributes other)
{
   swap(*this, other);

   return *this;
}

bool CallAttributes::operator==(const CallAttributes& rhs) const
{
   return ((this->_instance == rhs._instance)
         && (this->_state == rhs._state)
         && (this->_durationHr == rhs._durationHr)
         && (this->_durationMin == rhs._durationMin)
         && (this->_durationSec == rhs._durationSec)
         && (this->_mode == rhs._mode)
         && (this->_type == rhs._type)
         && (this->_direction == rhs._direction)
         && (this->_firstName == rhs._firstName)
         && (this->_lastName == rhs._lastName)
         && (this->_contactHandle == rhs._contactHandle)
         && (this->_isContactProvidedByClient == rhs._isContactProvidedByClient));
}

bool CallAttributes::operator!=(const CallAttributes& rhs) const
{
   return (!(operator==(rhs)));
}

void CallAttributes::adaptToPmCoreCallInfo(const pmcore::CallInfo& pmCoreCallInfo)
{
   _instance = pmCoreCallInfo._instance;
   _state = pmCoreCallInfo._state;
   _durationHr = pmCoreCallInfo._durationHr;
   _durationMin = pmCoreCallInfo._durationMin;
   _durationSec = pmCoreCallInfo._durationSec;
   _mode = pmCoreCallInfo._mode;
   _type = pmCoreCallInfo._type;
   _direction = pmCoreCallInfo._direction;
}

void CallAttributes::printCallAttributes()
{
   ETG_TRACE_USR4(("printCallAttributes::_instance: %u", _instance));
   ETG_TRACE_USR4(("printCallAttributes::_state: %s", _state.c_str()));
   ETG_TRACE_USR4(("printCallAttributes::_durationHr: %u", _durationHr));
   ETG_TRACE_USR4(("printCallAttributes::_durationMin: %u", _durationMin));
   ETG_TRACE_USR4(("printCallAttributes::_durationSec: %u", _durationSec));
   ETG_TRACE_USR4(("printCallAttributes::_mode: %u", ETG_CENUM(CallModeEnumType, _mode)));
   ETG_TRACE_USR4(("printCallAttributes::_type: %u", ETG_CENUM(NumberTypeEnumType, _type)));
   ETG_TRACE_USR4(("printCallAttributes::_direction: %u", ETG_CENUM(CallDirectionEnumType, _direction)));
   ETG_TRACE_USR4(("printCallAttributes::_firstName: %s", _firstName.c_str()));
   ETG_TRACE_USR4(("printCallAttributes::_lastName: %s", _lastName.c_str()));
   ETG_TRACE_USR4(("printCallAttributes::_contactHandle: %u", _contactHandle));
   ETG_TRACE_USR4(("printCallAttributes::_isContactProvidedByClient: %u", _isContactProvidedByClient));
}

} // namespace pmapp
} // namespace bosch
} // namespace com
