/**
 * @file PmAppClientHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmAppClientHandler class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef PmAppClientHandler_h
#define PmAppClientHandler_h

#include "BmAppRequestIf.h"
#include "PhoneBookRequestIf.h"
#include "LcmRequestIf.h"
#include "MediaPlayerRequestIf.h"
#include "DiagSystemSettings.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

/*
 * This class takes care of instantiating client handler classes of PM
 */
class PmAppClientHandler
{

public:

   /**
    * Constructor of PmAppClientHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   PmAppClientHandler();

   /**
    * Destructor of PmAppClientHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   ~PmAppClientHandler();

   /**
    * Copy constructor of PmAppClientHandler class
    *
    * @param[in] CcaMessageHandler& - Reference to PmAppClientHandler
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   PmAppClientHandler(const PmAppClientHandler&);

   /**
    * Assignment operator of PmAppClientHandler class
    *
    * @param[in] PmAppClientHandler& - Reference to PmAppClientHandler
    * @param[out]
    * @param[in,out]
    *
    * @return PmAppClientHandler& - Reference to PmAppClientHandler
    */
   PmAppClientHandler& operator=(const PmAppClientHandler&);

   /**
    * This functions returns the instance of IBmAppCallBackIf.
    *
    * @param[in]
    * @param[out] IBmAppCallBackIf* - Holds pointer to the IBmAppCallBackIf object
    * @param[in,out]
    *
    * @return IBmAppCallBackIf* -  Pointer to the IBmAppCallBackIf object
    */
   IBmAppCallBackIf* getBmAppCallBackIf();

   /**
    * This functions returns the instance of ILcmRequestIf.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return ILcmRequestIf* -  Pointer to the ILcmRequestIf object
    */
   ILcmRequestIf* getLcmRequestIf()
   {
      return _lcmRequestIf;
   }

   /**
    * This functions returns the instance of IBmAppRequestIf.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return IBmAppRequestIf* -  Pointer to the IBmAppRequestIf object
    */
   IBmAppRequestIf* getBmAppRequestIf()
   {
      return _bmAppRequestIf;
   }

   /**
    * This functions returns the instance of IPhoneBookRequestIf.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return IPhoneBookRequestIf* -  Pointer to the IPhoneBookRequestIf object
    */
   IPhoneBookRequestIf* getPhoneBookRequestIf()
   {
      return _phoneBookRequestIf;
   }

   /**
    * This functions returns the instance of IDiagSystemSettings.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return IPhoneBookRequestIf* -  Pointer to the IDiagSystemSettings object
    */
   IDiagSystemSettings* getDiagSystemSettings()
   {
      return _diagSystemSettings;
   }

private:
   ILcmRequestIf*          _lcmRequestIf;          /**< LcmClient request instance */
   IBmAppRequestIf*        _bmAppRequestIf;        /**< BmAppRequestIf instance */
   IPhoneBookRequestIf*    _phoneBookRequestIf;    /**< PhonebookClient instance */
   IMediaPlayerRequestIf*  _mediaPlayerRequestIf;  /**< MediaPlayer instance */
   IDiagSystemSettings*    _diagSystemSettings;    /**< DiagnosisClient instance */

   ILcmCallBackIf*         _lcmCallBackIf;         /**< LcmClient callback instance */
   IBmAppCallBackIf*       _bmAppCallBackIf;       /**< BmAppCallBackIf instance */
   IPhoneBookCallBackIf*   _phoneBookCallBackIf;   /**< PhoneBookCallBackIf instance */
   IMediaPlayerCallBackIf* _mediaPlayerCallBackIf; /**< MediaPlayerCallBackIf instance */
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif // PmAppClientHandler_h
