/**
 * @file MessageHandlerBase.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MessageHandlerBase class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file defines the Message Handler class
 *
 * @ingroup IpcWrapper
 */

#ifndef MessageHandlerBase_h
#define MessageHandlerBase_h

#include "IpcMsgTypes.h"

/*
 * This is the abstract base class for the template class IpcMessageHandler,
 * since the message handlers are decided during runtime based on the IPC
 * message received this base class could be used by the messages to specify the
 * appropriate message handler. TBD: Example to be specified.
 *
 */
class MessageHandlerBase
{

public:

   /**
    * Process the property updates from CPP interfaces. This method shall be overridden in the
    * respective derived classes property handlers to update the status to PM - clients
    *
    *
    * @param[in] PropertyUpdate* - Property data that has to be updated to the registered clients
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onPropertyUpdate(PropertyUpdate* pPropertyData) = 0;

   /**
    * Destructor of MessageHandlerBase class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~MessageHandlerBase(){ }
};

#endif // MessageHandlerBase_h
