/**
 * @file IpcMessageHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IpcMessageHandler class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file defines the template base class for all IPC message handlers.
 *
 * @ingroup IpcWrapper
 */

/*
 * This class is the template base class for all IPC message handlers.
 * All message handlers has to inherit this class.
 */

#ifndef IpcMessageHandler_h
#define IpcMessageHandler_h

#include "MessageHandlerBase.h"

template <typename TMessage>
class IpcMessageHandler : public virtual MessageHandlerBase
{

public:

   /**
    * Process Method request from different IPC. This method has to be overridden in the
    * respective derived classes message handlers to process the corresponding IPC message
    *
    *
    * @param[in] TMessage* - (TMessage is a template) place holder of the Message
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processMessage(TMessage* message) = 0;

   /**
    * Destructor of IpcMessageHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IpcMessageHandler(){ }
};

#endif // IpcMessageHandler_h
