/**
 * @file IPhoneBookCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the IPhoneBookCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for IPhoneBookCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef IPhoneBookCallBackIf_h
#define IPhoneBookCallBackIf_h

#include "IpcMsgTypes.h"

using namespace MOST_PhonBk_FI;

namespace com
{
namespace bosch
{
namespace pmapp
{

typedef ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy > MostPhonBkFiProxy;

class IPhoneBookCallBackIf : public MOST_PhonBk_FI::SearchPhoneBookCallbackIF
{
public:

   /**
    * Virtual destructor of IPhoneBookCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~IPhoneBookCallBackIf() {}

   /**
    * This function is used to set the proxy "MOST_PhonBk_FIProxy".
    * This proxy is received as one of the parameters in the callback functions.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setPhoneBookFiProxy(MostPhonBkFiProxy phoneBookFiProxy) = 0;

protected:
   /**
    * Error callback for searchPhonebook method.
    *
    * @param[in] MostPhonBkFiProxy - Registered Phonebook Fi proxy
    *            SearchPhoneBookError - Received Error status information for searchPhonebook method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void onSearchPhoneBookError(const MostPhonBkFiProxy& ,
         const ::boost::shared_ptr< MOST_PhonBk_FI::SearchPhoneBookError >& ) override = 0;

   /**
    * Callback function for searchPhonebook method call.
    *
    * @param[in] MostPhonBkFiProxy - Registered Phonebook Fi proxy
    *            SearchPhoneBookResult - Received result information for searchPhonebook method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void onSearchPhoneBookResult(const MostPhonBkFiProxy& ,
         const ::boost::shared_ptr< MOST_PhonBk_FI::SearchPhoneBookResult >& ) override = 0;

   MostPhonBkFiProxy _phoneBookFiProxy;
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //IPhoneBookCallBackIf_h
