/**
 * @file ILcmRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the ILcmRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for ILcmRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef ILcmRequestIf_h
#define ILcmRequestIf_h

namespace com
{
namespace bosch
{
namespace pmapp
{

class ILcmCallBackIf;

class ILcmRequestIf
{
public:

   /**
    * Virtual destructor of interface class ILcmRequestIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~ILcmRequestIf() {}

   /**
    * This function is called to set the callback interface object of the LCM service.
    *
    * @param[in] ILcmCallBackIf* - Pointer to the Callback Interface of LCM client.
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setLcmCallBackIf(ILcmCallBackIf*) = 0;

   /**
    * This function is used to set the phone substate property of LCM service.
    *
    * @param[in]  deviceAddress- Device address for which the Phone substate changes
    *             bool - Value of Phonesubstate boolean to be set
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setSpmPhoneSubState(const pmcore::BdAddress deviceAddress, const bool phoneSubState) = 0;

protected:
   /**
    * Parameterized constructor of ILcmRequestIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ILcmRequestIf(bool serviceAvailability, bool phoneSubState) :
      _serviceAvailability(serviceAvailability), _phoneSubState(phoneSubState)
   {
   }

   /**
    * Once the service is available, this function is called to register the required properties of LCM service.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() = 0;

   /**
    * Once the service becomes unavailable, this function is called to de-register
    * the registered properties of LCM service.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() = 0;

   bool _serviceAvailability;

   bool _phoneSubState;
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //ILcmRequestIf_h
