/**
 * @file ILcmCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the ILcmCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for ILcmCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef ILcmCallBackIf_h
#define ILcmCallBackIf_h

#include "IpcMsgTypes.h"

using namespace ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service;

namespace com
{
namespace bosch
{
namespace pmapp
{

typedef ::boost::shared_ptr< Lcm_dbus_fi_serviceProxy > LcmDBusFiProxy;

class ILcmCallBackIf : public SubStatesCallbackIF
, public SystemStateCallbackIF
, public OnOffTriggerCallbackIF
, public BluetoothStateCallbackIF
{
public:

   /**
    * Virtual destructor of interface class ILcmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~ILcmCallBackIf() {}

   /**
    * This function is used to set the proxy "Lcm_dbus_fi_serviceProxy".
    * This proxy is received as one of the parameters in the callback functions.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setLcmFiProxy(LcmDBusFiProxy lcmFiProxy) = 0;

protected:
   /**
    * Error callback for getSubStates

    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            SubStatesError - Received Error information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSubStatesError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SubStatesError >& error) override = 0;

   /**
    * This function is invoked when the "SubStates" property is updated.
    *
    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            SubStatesUpdate - Received SubStates Status information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSubStatesUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SubStatesUpdate >& update) override = 0;

   /**
    * Error callback for getSystemState

    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            SystemStateError - Received Error information
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSystemStateError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SystemStateError >& error) override = 0;

   /**
    * This function is invoked when the "SystemState" property is updated.
    *
    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            SystemStateUpdate - Received SystemState Status information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSystemStateUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< SystemStateUpdate >& update) override = 0;

   /**
    * Error callback for onOnOffTrigger method call.
    *
    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            OnOffTriggerError - Received Error status information for onOnOffTrigger method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOnOffTriggerError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< OnOffTriggerError >& error) override = 0;

   /**
    * Callback function for onOnOffTrigger method call
    *
    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            OnOffTriggerResponse - Received result information for onOnOffTrigger method call
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOnOffTriggerResponse(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< OnOffTriggerResponse >& response) override = 0;

   /**
    * Error callback for getBluetoothState

    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            BluetoothStateError - Received Error information
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onBluetoothStateError(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< BluetoothStateError >& error) override = 0;

   /**
    * This function is invoked when the "BluetoothState" property is updated.
    *
    * @param[in] LcmDBusFiProxy - Registered LCM Fi proxy
    *            BluetoothStateUpdate - Received BluetoothState Status information
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onBluetoothStateUpdate(const LcmDBusFiProxy& proxy,
         const ::boost::shared_ptr< BluetoothStateUpdate >& update) override = 0;

   LcmDBusFiProxy _lcmFiProxy;
};

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //ILcmCallBackIf_h
