/**
 * @file CcaWaitingModeFilePathHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaWaitingModeFilePathHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaWaitingModeFilePathHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaWaitingModeFilePathHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaWaitingModeFilePathHandler::CcaWaitingModeFilePathHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::CcaWaitingModeFilePathHandler entered"));
}

void CcaWaitingModeFilePathHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getWaitingModeFilePath(act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgWaitingModeFilePathStatus oWaitingModeFilePathStatus;

      oWaitingModeFilePathStatus.sFilePathNB.bSet((const char*)"");
      oWaitingModeFilePathStatus.sFilePathWB.bSet((const char*)"");

      updateOpcodeStatus(act, oWaitingModeFilePathStatus, PM_PROPERTYID_WAITINGMODEFILEPATH);
      oWaitingModeFilePathStatus.vDestroy();
   }
}

void CcaWaitingModeFilePathHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::onOpcodeSet entered"));

   most_telfi_tclMsgWaitingModeFilePathPureSet waitingModeFilePathMsg;

   getDataFromAmt(pInMsg, waitingModeFilePathMsg);

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if((waitingModeFilePathMsg.sFilePathNB.szValue)
         && (waitingModeFilePathMsg.sFilePathWB.szValue))
   {
      ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::sFilePathNB : %s", waitingModeFilePathMsg.sFilePathNB.szValue));
      ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::sFilePathWB : %s", waitingModeFilePathMsg.sFilePathWB.szValue));

      FilePath filePathNB(waitingModeFilePathMsg.sFilePathNB.szValue);
      FilePath filePathWB(waitingModeFilePathMsg.sFilePathWB.szValue);

      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().setWaitingModeFilePath(filePathNB, filePathWB, act);

      if(PM_RESULT_OK != pmresult._pmResultCode)
      {
         ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::onOpcodeSet failed"));
         PmCoreResponseData pmCoreResponseData(pmresult, act);
         processOpcodeSetError(&pmCoreResponseData);
      }
   }

   waitingModeFilePathMsg.vDestroy();
}

void CcaWaitingModeFilePathHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaWaitingModeFilePathHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaWaitingModeFilePathHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::dispatchProperty entered"));

   WaitingModeFilePathPropertyUpdate* waitingModeFilePathPropertyUpdate =
         static_cast<WaitingModeFilePathPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgWaitingModeFilePathStatus oWaitingModeFilePathStatus;

   oWaitingModeFilePathStatus.sFilePathNB.bSet
   (waitingModeFilePathPropertyUpdate->_waitingModeFilePath._filePathNB.c_str());

   oWaitingModeFilePathStatus.sFilePathWB.bSet
   (waitingModeFilePathPropertyUpdate->_waitingModeFilePath._filePathWB.c_str());

   ETG_TRACE_USR3(("oWaitingModeFilePathStatus.sFilePathNB: '%s'", oWaitingModeFilePathStatus.sFilePathNB.szValue));
   ETG_TRACE_USR3(("oWaitingModeFilePathStatus.sFilePathWB: '%s'", oWaitingModeFilePathStatus.sFilePathWB.szValue));

   updateOpcodeStatus(waitingModeFilePathPropertyUpdate->_u64TokenId, oWaitingModeFilePathStatus,
         waitingModeFilePathPropertyUpdate->u16GetFunctionID());
   oWaitingModeFilePathStatus.vDestroy();
}

void CcaWaitingModeFilePathHandler::processOpcodeSetError(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaWaitingModeFilePathHandler::processOpcodeSetError entered"));

   most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode;

//   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_BUSY"));
//   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_BUSY;

   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE"));
   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE;

   most_telfi_tclMsgWaitingModeFilePathError oWaitingModeFilePathError;
   oWaitingModeFilePathError.e8ErrorCode.enType = e8ErrorCode;

   updateOpcodeStatus(responseMsg->_u64TokenId, oWaitingModeFilePathError);
}
