/**
 * @file CcaVoiceRecognitionHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaVoiceRecognitionHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaVoiceRecognitionHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaVoiceRecognitionHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaVoiceRecognitionHandler::CcaVoiceRecognitionHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::CcaVoiceRecognitionHandler entered"));
   _activeDeviceHandle = PM_DEVICEHANDLE_ZERO;
}

void CcaVoiceRecognitionHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getVoiceRecognitionStatus(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgBTDeviceVoiceRecognitionStatus oBTDeviceVoiceRecStatus;

      oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecActive = false;

      // Need to check as of how to fill this variable
      oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported = false;

      updateOpcodeStatus(act, oBTDeviceVoiceRecStatus, PM_PROPERTYID_BTDEVICEVOICERECOGNITION);
      oBTDeviceVoiceRecStatus.vDestroy();
   }
}

void CcaVoiceRecognitionHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::onOpcodeSet entered"));

   most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet voiceRecognitionPureSet;

   getDataFromAmt(pInMsg, voiceRecognitionPureSet);

   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler:: BTDeviceVoiceRecActive : %u",
         voiceRecognitionPureSet.bBTDeviceVoiceRecActive));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postStartStopVoiceRecognitionRequest2PmCore(
         deviceAddress, voiceRecognitionPureSet.bBTDeviceVoiceRecActive, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::onOpcodeSet failed"));
      PmCoreResponseData pmCoreResponseData(pmresult, act);
      processOpcodeSetError(&pmCoreResponseData);
   }

   voiceRecognitionPureSet.vDestroy();
}

void CcaVoiceRecognitionHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaVoiceRecognitionHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaVoiceRecognitionHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::dispatchProperty entered"));

   VoiceRecognitionPropertyUpdate* voiceRecognitionPropertyUpdate =
         static_cast<VoiceRecognitionPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgBTDeviceVoiceRecognitionStatus oBTDeviceVoiceRecStatus;

   oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecActive = false;
   oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported = false;

   BdAddress activeDeviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(activeDeviceAddress);

   if (!activeDeviceAddress.empty())
   {
      if (activeDeviceAddress == voiceRecognitionPropertyUpdate->_deviceAddress)
      {
         DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
         ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
               (voiceRecognitionPropertyUpdate->_deviceAddress, deviceHandle);

         switch(voiceRecognitionPropertyUpdate->_updatedFieldMarker)
         {
            case VR_AVAILABILITY_STATUS:
            {
               if (voiceRecognitionPropertyUpdate->_vrAvailabilityStatus)
               {
                  _activeDeviceHandle = deviceHandle;
                  oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported = true;
               }
               else
               {
                  _activeDeviceHandle = PM_DEVICEHANDLE_ZERO;
               }
            }
            break;

            case VOICERECOGNITION_STATUS:
            {
               if (_activeDeviceHandle == deviceHandle)
               {
                  oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported = true;

                  if (VR_SESSION_ACTIVE == voiceRecognitionPropertyUpdate->_voiceRecognitionStatus._vrStatus)
                  {
                     oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecActive = true;
                  }
               }
            }
            break;

            default:
            {
               ETG_TRACE_USR4(("Default case"));
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("Update is for the Passive device. Hence ignoring it"));
         oBTDeviceVoiceRecStatus.vDestroy();
         return;
      }
   }

   ETG_TRACE_USR3(( "oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported= '%u'",
         oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecSupported));
   ETG_TRACE_USR3(( "oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecActive= '%u'",
         oBTDeviceVoiceRecStatus.bBTDeviceVoiceRecActive));

   updateOpcodeStatus(voiceRecognitionPropertyUpdate->_u64TokenId, oBTDeviceVoiceRecStatus,
         voiceRecognitionPropertyUpdate->u16GetFunctionID());
   oBTDeviceVoiceRecStatus.vDestroy();
}

void CcaVoiceRecognitionHandler::processOpcodeSetError(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaVoiceRecognitionHandler::processOpcodeSetError entered"));

   most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode;

//   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_BUSY"));
//   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_BUSY;

   ETG_TRACE_USR3((" most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE"));
   e8ErrorCode = most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE;

   most_telfi_tclMsgBTDeviceVoiceRecognitionError oBTDeviceVoiceRecognitionME;
   oBTDeviceVoiceRecognitionME.e8ErrorCode.enType = e8ErrorCode;

   updateOpcodeStatus(responseMsg->_u64TokenId, oBTDeviceVoiceRecognitionME);
}
