/**
 * @file CcaSystemWideRingtonesListHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSystemWideRingtonesListHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSystemWideRingtonesListHandler.h"
#include "FileUtils.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSystemWideRingtonesListHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSystemWideRingtonesListHandler::CcaSystemWideRingtonesListHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaSystemWideRingtonesListHandler::CcaSystemWideRingtonesListHandler entered"));
}

void CcaSystemWideRingtonesListHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaSystemWideRingtonesListHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getSystemWideRingtonesList(act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgSystemWideRingtonesListStatus oSystemWideRingtonesListStatus;
      updateOpcodeStatus(act, oSystemWideRingtonesListStatus, PM_PROPERTYID_SYSTEMWIDERINGTONESLIST);
      oSystemWideRingtonesListStatus.vDestroy();
   }
}

void CcaSystemWideRingtonesListHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_SYSTEMWIDERINGTONESLIST, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaSystemWideRingtonesListHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSystemWideRingtonesListHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaSystemWideRingtonesListHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSystemWideRingtonesListHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaSystemWideRingtonesListHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaSystemWideRingtonesListHandler::dispatchProperty entered"));

   SystemWideRingtonesListPropertyUpdate* systemWideRingtonesListPropertyUpdate =
         static_cast<SystemWideRingtonesListPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgSystemWideRingtonesListStatus oSystemWideRingtonesListStatus;
   most_fi_tcl_TelSystemWideRingtonesListResultItem  oSystemWideRingtonesListResultItem;

   oSystemWideRingtonesListStatus.u8ActiveSystemRingtoneID =
         static_cast<tU8>(systemWideRingtonesListPropertyUpdate->_systemwideRingtonesList._activeSystemRingtoneId);

   ETG_TRACE_USR4(("oSystemWideRingtonesListStatus.u8ActiveSystemRingtoneID: %d",
         oSystemWideRingtonesListStatus.u8ActiveSystemRingtoneID));

   SystemRingtonesList systemRingtonesList = systemWideRingtonesListPropertyUpdate->_systemwideRingtonesList._systemRingtonesList;

   for (auto& systemRingtones : systemRingtonesList)
   {
      oSystemWideRingtonesListResultItem.u8RingtoneID = static_cast<tU8>(systemRingtones._ringtoneId);
      std::string ringtoneName;
      (void)com::bosch::pmcommon::getFileNameFromFilePath(systemRingtones._ringtoneName, ringtoneName);
      oSystemWideRingtonesListResultItem.sRingtoneName.bSet(ringtoneName.c_str());

      ETG_TRACE_USR4(("oSystemWideRingtonesListResultItem.u8RingtoneID: %d",
            oSystemWideRingtonesListResultItem.u8RingtoneID));
      ETG_TRACE_USR4(("oSystemWideRingtonesListResultItem.sRingtoneName: %s",
            oSystemWideRingtonesListResultItem.sRingtoneName.szGet()));

      oSystemWideRingtonesListStatus.oSystemWideRingtonesListResult.oItems.push_back(oSystemWideRingtonesListResultItem);
   }

   updateOpcodeStatus(systemWideRingtonesListPropertyUpdate->_u64TokenId, oSystemWideRingtonesListStatus,
         systemWideRingtonesListPropertyUpdate->u16GetFunctionID());

   oSystemWideRingtonesListStatus.vDestroy();
}

void CcaSystemWideRingtonesListHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
