/**
 * @file CcaHFServiceHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaHFServiceHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaHFServiceHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaHFServiceHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaHFServiceHandler::CcaHFServiceHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaHFServiceHandler::CcaHFServiceHandler entered"));
}

void CcaHFServiceHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaHFServiceHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getSupportedFeatures(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgHFServiceStatus hfServiceStatus;
      updateOpcodeStatus(act, hfServiceStatus, PM_PROPERTYID_HFSERVICE);
      hfServiceStatus.vDestroy();
   }
}

void CcaHFServiceHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_HFSERVICE, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaHFServiceHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaHFServiceHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaHFServiceHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaHFServiceHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaHFServiceHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaHFServiceHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<SupportedFeatures>* supportedFeaturesPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<SupportedFeatures>*> (propertyUpdate);

   most_telfi_tclMsgHFServiceStatus hfServiceStatus;
   hfServiceStatus.bCallWaitAvail = false;
   hfServiceStatus.bThreeWayCallAvail = false;

   SupportedFeaturesType supportedFeaturesList = supportedFeaturesPropertyUpdate->_value._supportedFeatures;

   for (auto& supportedFeature : supportedFeaturesList)
   {
      if ("3way" == supportedFeature)
      {
         hfServiceStatus.bCallWaitAvail = true;
         hfServiceStatus.bThreeWayCallAvail = true;
         break;
      }
   }

   ETG_TRACE_USR1(("hfServiceStatus.bCallWaitAvail: %u", hfServiceStatus.bCallWaitAvail));
   ETG_TRACE_USR1(("hfServiceStatus.bThreeWayCallAvail: %u", hfServiceStatus.bThreeWayCallAvail));

   updateOpcodeStatus(supportedFeaturesPropertyUpdate->_u64TokenId, hfServiceStatus,
         supportedFeaturesPropertyUpdate->u16GetFunctionID());
   hfServiceStatus.vDestroy();
}

void CcaHFServiceHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
