/**
 * @file CcaCellStateOfChargeHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCellStateOfChargeHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCellStateOfChargeHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCellStateOfChargeHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCellStateOfChargeHandler::CcaCellStateOfChargeHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaCellStateOfChargeHandler::CcaCellStateOfChargeHandler entered"));
}

void CcaCellStateOfChargeHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaCellStateOfChargeHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getBatteryChargeLevel(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgCellStateofChargeStatus oCellStateOfChargeStatus;

      oCellStateOfChargeStatus.u8StateofCharge = BATTERY_CHARGE_LEVEL_DEFAULT;
      oCellStateOfChargeStatus.u8DeviceHandle = PM_DEVICEHANDLE_ZERO;

      updateOpcodeStatus(act, oCellStateOfChargeStatus, PM_PROPERTYID_CELLSTATEOFCHARGE);
      oCellStateOfChargeStatus.vDestroy();
   }
}

void CcaCellStateOfChargeHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_CELLSTATEOFCHARGE, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaCellStateOfChargeHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellStateOfChargeHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaCellStateOfChargeHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCellStateOfChargeHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaCellStateOfChargeHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellStateOfChargeHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<BatteryChargeLevel>* batteryChargeLevelPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<BatteryChargeLevel>*> (propertyUpdate);

   most_telfi_tclMsgCellStateofChargeStatus oCellStateOfChargeStatus;

   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
         (batteryChargeLevelPropertyUpdate->_deviceAddress, deviceHandle);

   if ((batteryChargeLevelPropertyUpdate->_value._batteryChargeLevel == BATTERY_CHARGE_LEVEL_DEFAULT) ||
         (batteryChargeLevelPropertyUpdate->_value._batteryChargeLevel <= BATTERY_CHARGE_MAX_VALUE))
   {
      oCellStateOfChargeStatus.u8StateofCharge = batteryChargeLevelPropertyUpdate->_value._batteryChargeLevel;
   }
   else
   {
      oCellStateOfChargeStatus.u8StateofCharge = BATTERY_CHARGE_LEVEL_DEFAULT;
   }
   oCellStateOfChargeStatus.u8DeviceHandle = deviceHandle;

   ETG_TRACE_USR1(("oCellStateOfChargeStatus: %u", oCellStateOfChargeStatus.u8StateofCharge));
   ETG_TRACE_USR1(("oCellStateOfChargeStatus.u8DeviceHandle: %u", oCellStateOfChargeStatus.u8DeviceHandle));

   updateOpcodeStatus(batteryChargeLevelPropertyUpdate->_u64TokenId, oCellStateOfChargeStatus,
         batteryChargeLevelPropertyUpdate->u16GetFunctionID());

   oCellStateOfChargeStatus.vDestroy();
}

void CcaCellStateOfChargeHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
