/**
 * @file CcaCellSignalStrengthHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCellSignalStrengthHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCellSignalStrengthHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCellSignalStrengthHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCellSignalStrengthHandler::CcaCellSignalStrengthHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaCellSignalStrengthHandler::CcaCellSignalStrengthHandler entered"));
}

void CcaCellSignalStrengthHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaCellSignalStrengthHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getSignalStrength(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgCellSignalStrengthStatus oCellSignalStrengthStatus;

      oCellSignalStrengthStatus.u8SignalSrength = SIGNAL_STRENGTH_DEFAULT;
      oCellSignalStrengthStatus.u8DeviceHandle = PM_DEVICEHANDLE_ZERO;

      updateOpcodeStatus(act, oCellSignalStrengthStatus, PM_PROPERTYID_CELLSIGNALSTRENGTH);

      oCellSignalStrengthStatus.vDestroy();
   }
}

void CcaCellSignalStrengthHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_CELLSIGNALSTRENGTH, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaCellSignalStrengthHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellSignalStrengthHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaCellSignalStrengthHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCellSignalStrengthHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaCellSignalStrengthHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellSignalStrengthHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<SignalStrength>* signalStrengthPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<SignalStrength>*> (propertyUpdate);

   most_telfi_tclMsgCellSignalStrengthStatus oCellSignalStrengthStatus;

   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
         (signalStrengthPropertyUpdate->_deviceAddress, deviceHandle);

   if ((SIGNAL_STRENGTH_DEFAULT == signalStrengthPropertyUpdate->_value._signalStrength) ||
         (signalStrengthPropertyUpdate->_value._signalStrength <= SIGNAL_STRENGTH_MAX_VALUE))
   {
      oCellSignalStrengthStatus.u8SignalSrength = signalStrengthPropertyUpdate->_value._signalStrength;
   }
   else
   {
      oCellSignalStrengthStatus.u8SignalSrength = SIGNAL_STRENGTH_DEFAULT;
   }


   ETG_TRACE_USR1(("oCellSignalStrengthStatus:%d", oCellSignalStrengthStatus.u8SignalSrength));

   oCellSignalStrengthStatus.u8DeviceHandle = deviceHandle;
   ETG_TRACE_USR1(("oCellSignalStrengthStatus.u8DeviceHandle:%d", oCellSignalStrengthStatus.u8DeviceHandle));

   updateOpcodeStatus(signalStrengthPropertyUpdate->_u64TokenId, oCellSignalStrengthStatus,
         signalStrengthPropertyUpdate->u16GetFunctionID());

   oCellSignalStrengthStatus.vDestroy();
}

void CcaCellSignalStrengthHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
