/**
 * @file CcaCellNetworkStatusHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCellNetworkStatusHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCellNetworkStatusHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCellNetworkStatusHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCellNetworkStatusHandler::CcaCellNetworkStatusHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaCellNetworkStatusHandler::CcaCellNetworkStatusHandler entered"));
}

void CcaCellNetworkStatusHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaCellNetworkStatusHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getNetworkStatus(deviceAddress, act);

   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgCellNetworkStatusStatus oCellNetworkStatusStatus;

      oCellNetworkStatusStatus.e8CellService.enType = most_fi_tcl_e8_TelCellService::FI_EN_E8NO_SERVICE;
      oCellNetworkStatusStatus.bRoamingStatus = false;

      oCellNetworkStatusStatus.u8DeviceHandle = PM_DEVICEHANDLE_ZERO;

      updateOpcodeStatus(act, oCellNetworkStatusStatus, PM_PROPERTYID_CELLNETWORKSTATUS);
      oCellNetworkStatusStatus.vDestroy();
   }
}

void CcaCellNetworkStatusHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_CELLNETWORKSTATUS, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaCellNetworkStatusHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellNetworkStatusHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaCellNetworkStatusHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaCellNetworkStatusHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellNetworkStatusHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<NetworkStatus>* networkStatusPropertyUpdate =
         static_cast<AgInfoPropertyUpdate<NetworkStatus>*> (propertyUpdate);

   most_telfi_tclMsgCellNetworkStatusStatus oCellNetworkStatusStatus;

   NetworkStatusType networkStatus = networkStatusPropertyUpdate->_value._networkStatus;
   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
         (networkStatusPropertyUpdate->_deviceAddress, deviceHandle);
   switch (networkStatus)
   {
      case NETWORK_STATUS_ROAMING:
      {
         oCellNetworkStatusStatus.e8CellService.enType = most_fi_tcl_e8_TelCellService::FI_EN_E8SERVICE;
         oCellNetworkStatusStatus.bRoamingStatus = true;
      }
      break;

      case NETWORK_STATUS_REGISTERED:
      {
         oCellNetworkStatusStatus.e8CellService.enType = most_fi_tcl_e8_TelCellService::FI_EN_E8SERVICE;
         oCellNetworkStatusStatus.bRoamingStatus = false;
      }
      break;

      default:
      {
         oCellNetworkStatusStatus.e8CellService.enType = most_fi_tcl_e8_TelCellService::FI_EN_E8NO_SERVICE;
         oCellNetworkStatusStatus.bRoamingStatus = false;
      }
   }

   oCellNetworkStatusStatus.u8DeviceHandle = deviceHandle;

   ETG_TRACE_USR1(("oCellNetworkStatusStatus.bRoamingStatus: %u",oCellNetworkStatusStatus.bRoamingStatus));
   ETG_TRACE_USR1(("oCellNetworkStatusStatus.u8DeviceHandle: %u",oCellNetworkStatusStatus.u8DeviceHandle));

   updateOpcodeStatus(networkStatusPropertyUpdate->_u64TokenId, oCellNetworkStatusStatus,
         networkStatusPropertyUpdate->u16GetFunctionID());

   oCellNetworkStatusStatus.vDestroy();
}

void CcaCellNetworkStatusHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
