/**
 * @file CcaCellDeviceNameHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCellDeviceNameHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCellDeviceNameHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCellDeviceNameHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCellDeviceNameHandler::CcaCellDeviceNameHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::CcaCellDeviceNameHandler entered"));
}

void CcaCellDeviceNameHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::onOpcodeGet entered"));
   (void) pInMsg;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().getDeviceFriendlyName(deviceAddress, act);
}

void CcaCellDeviceNameHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_CELLDEVICENAME, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaCellDeviceNameHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaCellDeviceNameHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaCellDeviceNameHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCellDeviceNameHandler::dispatchProperty entered"));

   AgInfoPropertyUpdate<FriendlyName>* friendlyNamePropertyUpdate =
         static_cast<AgInfoPropertyUpdate<FriendlyName>*> (propertyUpdate);

   most_telfi_tclMsgCellDeviceNameStatus oCellDeviceNameStatus;

   DeviceHandle deviceHandle = PM_DEVICEHANDLE_ZERO;
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceHandle
         (friendlyNamePropertyUpdate->_deviceAddress, deviceHandle);

   oCellDeviceNameStatus.u8DeviceHandle = deviceHandle;

   if (PM_DEVICEHANDLE_ZERO == deviceHandle)
   {
      oCellDeviceNameStatus.sDeviceName.bSet((const char*)"");
   }
   else
   {
      oCellDeviceNameStatus.sDeviceName.bSet(friendlyNamePropertyUpdate->_value._friendlyName.c_str());
   }

   ETG_TRACE_USR1(("oCellDeviceNameStatus.sDeviceName:%s", oCellDeviceNameStatus.sDeviceName.szGet()));
   ETG_TRACE_USR1(("oCellDeviceNameStatus.u8DeviceHandle:%d",oCellDeviceNameStatus.u8DeviceHandle));

   updateOpcodeStatus(friendlyNamePropertyUpdate->_u64TokenId, oCellDeviceNameStatus,
         friendlyNamePropertyUpdate->u16GetFunctionID());
   oCellDeviceNameStatus.vDestroy();
}

void CcaCellDeviceNameHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
