/**
 * @file CcaCallOperationFailedEventHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCallOperationFailedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCallOperationFailedEventHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCallOperationFailedEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCallOperationFailedEventHandler::CcaCallOperationFailedEventHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler::CcaCallOperationFailedEventHandler entered"));
}

void CcaCallOperationFailedEventHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // Get is not possible for this property. This function will be invoked only during UPREG.
   // As of now the default value is updated.
   most_telfi_tclMsgCallOperationFailedEventStatus oCallOperationFailedEventStatus;
   most_fi_tcl_ListOfCallInstanceStreamItem oListOfCallInstanceStreamItem;

   oCallOperationFailedEventStatus.sBdAddress.bSet((const char*)"");
   oCallOperationFailedEventStatus.sOperation.bSet((const char*)"");
   oCallOperationFailedEventStatus.sCallOperationFailedReason.bSet((const char*)"");

   oListOfCallInstanceStreamItem.u16CallInstance = CALL_INSTANCE_DEFAULT;
   oCallOperationFailedEventStatus.oListOfCallInstanceStream.oItems.push_back(oListOfCallInstanceStreamItem);

   updateOpcodeStatus(act, oCallOperationFailedEventStatus, PM_PROPERTYID_CALLOPERATIONFAILEDEVENT);
   oCallOperationFailedEventStatus.vDestroy();
}

void CcaCallOperationFailedEventHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_CALLOPERATIONFAILEDEVENT, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaCallOperationFailedEventHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler::onPropertyUpdate entered"));
   dispatchProperty(propertyUpdate);
}

void CcaCallOperationFailedEventHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler::processOpcodeGetResponse entered"));
   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaCallOperationFailedEventHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler::dispatchProperty entered"));

   PmNotificationEventPropertyUpdate* callOperationFailedEvent =
         static_cast<PmNotificationEventPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgCallOperationFailedEventStatus oCallOperationFailedEventStatus;

   std::map<std::string, std::string> eventInfoMap = callOperationFailedEvent->_eventInfoMap;

   BdAddress deviceAddress = "";
   std::string errorName = "";
   std::string failedReason = "";

   auto eventInfoMapIter = eventInfoMap.find("DeviceAddress");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      deviceAddress = eventInfoMapIter->second;
   }

   eventInfoMapIter = eventInfoMap.find("EventName");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      errorName = eventInfoMapIter->second;
   }

   eventInfoMapIter = eventInfoMap.find("FailureReason");
   if (eventInfoMap.end() != eventInfoMapIter)
   {
      failedReason = eventInfoMapIter->second;
   }

   oCallOperationFailedEventStatus.sBdAddress.bSet(deviceAddress.c_str());
   oCallOperationFailedEventStatus.sOperation.bSet(errorName.c_str());
   oCallOperationFailedEventStatus.sCallOperationFailedReason.bSet(failedReason.c_str());

   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler: deviceAddress : %s", deviceAddress.c_str()));
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler: errorName : %s", errorName.c_str()));
   ETG_TRACE_USR4(("CcaCallOperationFailedEventHandler: failedReason : %s", failedReason.c_str()));

   for (uint8 ListIndex = 0; ListIndex < callOperationFailedEvent->_callInstanceList.size(); ListIndex++)
   {
      most_fi_tcl_ListOfCallInstanceStreamItem oListOfCallInstanceStreamItem;

      CCACallInstance ccaCallInstance = CCA_CALL_INSTANCE_DEFAULT;
      CcaCallStatusListHandler::getInstance().getCCACallInstance(deviceAddress,
            callOperationFailedEvent->_callInstanceList.at(ListIndex), ccaCallInstance);

      oListOfCallInstanceStreamItem.u16CallInstance = ccaCallInstance;

      ETG_TRACE_USR4(("oListOfCallInstanceStreamItem.u16CallInstance : %u", oListOfCallInstanceStreamItem.u16CallInstance));
      oCallOperationFailedEventStatus.oListOfCallInstanceStream.oItems.push_back(oListOfCallInstanceStreamItem);
   }

   updateOpcodeStatus(callOperationFailedEvent->_u64TokenId, oCallOperationFailedEventStatus,
         PM_PROPERTYID_CALLOPERATIONFAILEDEVENT);
   oCallOperationFailedEventStatus.vDestroy();
}

void CcaCallOperationFailedEventHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
