/**
 * @file CcaAutoWaitingModeOnOffListHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaAutoWaitingModeOnOffListHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaAutoWaitingModeOnOffListHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaAutoWaitingModeOnOffListHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaAutoWaitingModeOnOffListHandler::CcaAutoWaitingModeOnOffListHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffListHandler::CcaAutoWaitingModeOnOffListHandler entered"));
}

void CcaAutoWaitingModeOnOffListHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffListHandler::onOpcodeGet entered"));
   (void) pInMsg;

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getAutoWaitingModeOnOffList(act);
   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      most_telfi_tclMsgAutoWaitingModeOnOffListStatus autoWaitingModeOnOffListStatus;
      updateOpcodeStatus(act, autoWaitingModeOnOffListStatus, PM_PROPERTYID_AUTOWAITINGMODEONOFFLIST);
      autoWaitingModeOnOffListStatus.vDestroy();
   }
}

void CcaAutoWaitingModeOnOffListHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_AUTOWAITINGMODEONOFFLIST, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaAutoWaitingModeOnOffListHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffListHandler::onPropertyUpdate entered"));

   dispatchProperty(propertyUpdate);
}

void CcaAutoWaitingModeOnOffListHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffListHandler::processOpcodeGetResponse entered"));

   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaAutoWaitingModeOnOffListHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffListHandler::dispatchProperty entered"));

   AutoWaitingModeOnOffListPropertyUpdate* autoWaitingModeOnOffListPropertyUpdate =
         static_cast<AutoWaitingModeOnOffListPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgAutoWaitingModeOnOffListStatus autoWaitingModeOnOffListStatus;
   most_fi_tcl_TelAutoWaitingModeOnOffListResultItem  autoWaitingModeOnOffListResultItem;

   AutoWaitingModeOnOffListMap autoWaitingModeOnOffListMap =
         autoWaitingModeOnOffListPropertyUpdate->_autoWaitingModeOnOffList._autoWaitingModeOnOffList;

   for (auto& iter : autoWaitingModeOnOffListMap)
   {
      autoWaitingModeOnOffListResultItem.sBdAddress.bSet(iter.first.c_str());
      autoWaitingModeOnOffListResultItem.bAutoWaitingModeState = iter.second;
      autoWaitingModeOnOffListStatus.oAutoWaitingModeOnOffListResult.oItems.push_back(autoWaitingModeOnOffListResultItem);
   }

   updateOpcodeStatus(autoWaitingModeOnOffListPropertyUpdate->_u64TokenId, autoWaitingModeOnOffListStatus,
         autoWaitingModeOnOffListPropertyUpdate->u16GetFunctionID());

   autoWaitingModeOnOffListStatus.vDestroy();
}

void CcaAutoWaitingModeOnOffListHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
