/**
 * @file CcaActiveCallInHandsetHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaActiveCallInHandsetHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaActiveCallInHandsetHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaActiveCallInHandsetHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaActiveCallInHandsetHandler::CcaActiveCallInHandsetHandler(ahl_tclBaseOneThreadService* pAhlService)
: CcaProperty(pAhlService)
{
   ETG_TRACE_USR4(("CcaActiveCallInHandsetHandler::CcaActiveCallInHandsetHandler entered"));
}

void CcaActiveCallInHandsetHandler::onOpcodeGet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_USR4(("CcaActiveCallInHandsetHandler::onOpcodeGet entered"));
   (void) pInMsg;

   // This property implies whether the call audio is in Handset or vehicle.
   // Hence using "getPhoneCallAudioActive()"
   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getPhoneCallAudioActive(act);
   if(PM_RESULT_OK != pmresult._pmResultCode)
   {
      // Send the default value
      most_telfi_tclMsgActiveCallinHandsetStatus oActiveCallinHandsetStatus;
      updateOpcodeStatus(act, oActiveCallinHandsetStatus, PM_PROPERTYID_ACTIVECALLINHANDSET);
      oActiveCallinHandsetStatus.vDestroy();
   }
}

void CcaActiveCallInHandsetHandler::onOpcodeSet(amt_tclServiceData* pInMsg, const ActType act)
{
   ETG_TRACE_ERR(("Received an invalid opcode - SET for MOST_TELFI_C_U16_ACTIVECALLINHANDSET, FID: %u",
         pInMsg->u16GetFunctionID()));

   // Set is not possible, Hence removing the token from the table.
   removeEntryFromRequestMap(act);
}

void CcaActiveCallInHandsetHandler::onPropertyUpdate(PropertyUpdate* propertyUpdate)
{
   ETG_TRACE_USR4(("CcaActiveCallInHandsetHandler::onPropertyUpdate entered"));

   dispatchProperty(propertyUpdate);
}

void CcaActiveCallInHandsetHandler::processOpcodeGetResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaActiveCallInHandsetHandler::processOpcodeGetResponse entered"));

   dispatchProperty(responseMsg);
}

template<typename TPropertyType>
void CcaActiveCallInHandsetHandler::dispatchProperty(TPropertyType* propertyUpdate)
{
   PhoneCallAudioPropertyUpdate* phoneCallAudioPropertyUpdate =
         static_cast<PhoneCallAudioPropertyUpdate*> (propertyUpdate);

   most_telfi_tclMsgActiveCallinHandsetStatus oActiveCallinHandsetStatus;
   most_fi_tcl_TelActiveCallinHandsetStreamItem oActiveCallinHandsetStreamItem;

   //oActiveCallinHandsetStreamItem.u8DeviceHandle = m_u8ActiveDeviceHandle;
   oActiveCallinHandsetStatus.oActiveCallinHandsetStream.oItems.push_back(oActiveCallinHandsetStreamItem);

   // TODO: Need to check FC_phone code for further changes in this property
   updateOpcodeStatus(phoneCallAudioPropertyUpdate->_u64TokenId, oActiveCallinHandsetStatus,
         phoneCallAudioPropertyUpdate->u16GetFunctionID());

   oActiveCallinHandsetStatus.vDestroy();
}

void CcaActiveCallInHandsetHandler::processOpcodeSetError(PmCoreResponseData* pInMsg)
{
   (void) pInMsg;
}
