/**
 * @file CcaVoiceMailReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaVoiceMailReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaVoiceMailReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaVoiceMailReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaVoiceMailReqHandler::CcaVoiceMailReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaVoiceMailReqHandler::CcaVoiceMailReqHandler entered"));
}

void CcaVoiceMailReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaVoiceMailReqHandler::onMethodStart entered"));

   most_telfi_tclMsgVoiceMailMethodStart voiceMailMsg;

   getDataFromAmt(pInMsg, voiceMailMsg);

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if(nullptr != voiceMailMsg.sDeviceName.szValue)
   {
      ETG_TRACE_USR4(("CcaVoiceMailReqHandler::onMethodStart DeviceName : %s", voiceMailMsg.sDeviceName.szValue));

      BdAddress deviceAddress = "";
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().getVoiceMailList(deviceAddress, ccaToken);
   }

   handlePmResult(pmresult, ccaToken);
   voiceMailMsg.vDestroy();
}

void CcaVoiceMailReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaVoiceMailReqHandler::processMethodResponse entered"));

   VoiceMailListResponseMsg* voiceMailListResponseMsg = static_cast<VoiceMailListResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("voiceMailListResponseMsg->_u64TokenId : %u", voiceMailListResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == voiceMailListResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgVoiceMailMethodResult oVoiceMailMR;

      // TODO: To be decided on how to populate the variable- "sVoiceMailNumber"
      //oVoiceMailMR.sVoiceMailNumber.bSet(psVoiceMailNumber);
      sendMethodResult(voiceMailListResponseMsg->_u64TokenId, oVoiceMailMR);
      oVoiceMailMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaVoiceMailReqHandler::processMethodResponse - Error response for voice mail request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(voiceMailListResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
