/**
 * @file CcaTransferCallToVehicleReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaTransferCallToVehicleReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaTransferCallToVehicleReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaTransferCallToVehicleReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaTransferCallToVehicleReqHandler::CcaTransferCallToVehicleReqHandler(ahl_tclBaseOneThreadService* pService)
: CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaTransferCallToVehicleReqHandler::CcaTransferCallToVehicleReqHandler entered"));
}

void CcaTransferCallToVehicleReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaTransferCallToVehicleReqHandler::onMethodStart entered"));

   most_telfi_tclMsgTransferCallToVehicleMethodStart transferCallToVehicleMsg;

   getDataFromAmt(pInMsg, transferCallToVehicleMsg);

   ETG_TRACE_USR4(("CcaTransferCallToVehicleReqHandler::onMethodStart DeviceHandle : %u",
         transferCallToVehicleMsg.u8DeviceHandle));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceAddress
         (transferCallToVehicleMsg.u8DeviceHandle, deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postTransferAudioRequest2PmCore(deviceAddress,
         AUDIO_DIRECTION_HANDSFREE, ccaToken);

   handlePmResult(pmresult, ccaToken);

   transferCallToVehicleMsg.vDestroy();
}

void CcaTransferCallToVehicleReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaTransferCallToVehicleReqHandler::processMethodResponse entered"));

   TransferAudioResponseMsg* transferAudioResponseMsg = static_cast<TransferAudioResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("transferAudioResponseMsg->_u64TokenId : %u", transferAudioResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == transferAudioResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgTransferCallToVehicleMethodResult oTransferCallVehicleMR;

//      oTransferCallVehicleMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;
//      oTransferCallVehicleMR.u8DeviceHandle = m_u8ActiveDeviceHandle;

      sendMethodResult(transferAudioResponseMsg->_u64TokenId, oTransferCallVehicleMR);
      oTransferCallVehicleMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaTransferCallToVehicleReqHandler::processMethodResponse - "
            "Error response for transfer call to vehicle request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(transferAudioResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
