/**
 * @file CcaSuppressRingtoneOnOffReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSuppressRingtoneOnOffReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSuppressRingtoneOnOffReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSuppressRingtoneOnOffReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSuppressRingtoneOnOffReqHandler::CcaSuppressRingtoneOnOffReqHandler(ahl_tclBaseOneThreadService* pService) :
      CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffReqHandler::CcaSuppressRingtoneOnOffReqHandler entered"));
}

void CcaSuppressRingtoneOnOffReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSuppressRingtoneOnOffMethodStart suppressRingtoneOnOffMsg;

   getDataFromAmt(pInMsg, suppressRingtoneOnOffMsg);

   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffReqHandler::BdAddress %s", suppressRingtoneOnOffMsg.sBdAddress.szValue));
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffReqHandler::SuppressRingtoneState %d",
         suppressRingtoneOnOffMsg.bSuppressRingtoneState));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postSuppressRingtoneOnOffRequest2PmCore(
         suppressRingtoneOnOffMsg.sBdAddress.szValue, suppressRingtoneOnOffMsg.bSuppressRingtoneState, ccaToken);

   handlePmResult(pmResult, ccaToken);

   suppressRingtoneOnOffMsg.vDestroy();
}

void CcaSuppressRingtoneOnOffReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSuppressRingtoneOnOffReqHandler::processMethodResponse entered"));

   PmCoreResponseData* suppressRingtoneOnOffResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("suppressRingtoneOnOffResponseMsg->_u64TokenId: %u", suppressRingtoneOnOffResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == suppressRingtoneOnOffResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSuppressRingtoneOnOffMethodResult suppressRingtoneOnOffMethodResult;

      sendMethodResult(suppressRingtoneOnOffResponseMsg->_u64TokenId, suppressRingtoneOnOffMethodResult);

      suppressRingtoneOnOffMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSuppressRingtoneOnOffReqHandler::processMethodResponse - Error response for"
            " suppress ringtone on off request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(suppressRingtoneOnOffResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
