/**
 * @file CcaStartStopWaitingModeReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaStartStopWaitingModeReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaStartStopWaitingModeReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaStartStopWaitingModeReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaStartStopWaitingModeReqHandler::CcaStartStopWaitingModeReqHandler
(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaStartStopWaitingModeReqHandler::CcaStartStopWaitingModeReqHandler entered"));
}

void CcaStartStopWaitingModeReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaStartStopWaitingModeReqHandler::onMethodStart entered"));

   most_telfi_tclMsgStartStopWaitingModeMethodStart startStopWaitingModeMsg;

   getDataFromAmt(pInMsg, startStopWaitingModeMsg);

   ETG_TRACE_USR4(("CcaStartStopWaitingModeReqHandler::onMethodStart WaitingModeAction : %u",
         startStopWaitingModeMsg.e8WaitingModeAction.enType));

   StartStop startStopWaitingMode = !(startStopWaitingModeMsg.e8WaitingModeAction.enType);

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postStartStopWaitingModeRequest2PmCore(deviceAddress,
         startStopWaitingMode, ccaToken);

   handlePmResult(pmresult, ccaToken);

   startStopWaitingModeMsg.vDestroy();
}

void CcaStartStopWaitingModeReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaStartStopWaitingModeReqHandler::processMethodResponse entered"));

   StartStopwaitingModeResponseMsg* startStopwaitingModeResponseMsg =
         static_cast<StartStopwaitingModeResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("startStopwaitingModeResponseMsg->_u64TokenId : %u",
         startStopwaitingModeResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == startStopwaitingModeResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgStartStopWaitingModeMethodResult oStartStopWaitingModeMR;

      //oStartStopWaitingModeMR.e8WaitingModeStatus.enType = enWaitingModeStatus;

      sendMethodResult(startStopwaitingModeResponseMsg->_u64TokenId, oStartStopWaitingModeMR);
      oStartStopWaitingModeMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaStartStopWaitingModeReqHandler::processMethodResponse"
            " - Error response for StartStopWaitingmode request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(startStopwaitingModeResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
