/**
 * @file CcaSplitCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSplitCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSplitCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSplitCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSplitCallReqHandler::CcaSplitCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSplitCallReqHandler::CcaSplitCallReqHandler entered"));
}

void CcaSplitCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSplitCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSplitCallMethodStart splitCallMsg;
   
   getDataFromAmt(pInMsg, splitCallMsg);
   
   ETG_TRACE_USR4(("CcaSplitCallReqHandler::onMethodStart CallInstance : %d", splitCallMsg.u16CallInstance));

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");
   BdAddress deviceAddress = "";
   DeviceCallInstanceListMap splitCallList;
   CallInstanceList callsList;

   if (CALL_INSTANCE_DEFAULT == splitCallMsg.u16CallInstance)
   {
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

      if (!deviceAddress.empty())
      {
         callsList.push_back(CALL_INSTANCE_DEFAULT);

         splitCallList.emplace_hint(splitCallList.end(), deviceAddress, callsList);
         pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSplitCallsRequest2PmCore(splitCallList, ccaToken);
      }
      else
      {
         pmresult._pmResultCode = PM_RESULT_ERR_DEVICE_NOT_EXIST;
      }
   }
   else
   {
      CallInstance pmcoreCallInstance = CALL_INSTANCE_DEFAULT;

      CcaCallStatusListHandler::getInstance().convertCCACallInstance(splitCallMsg.u16CallInstance,
            deviceAddress, pmcoreCallInstance);

      callsList.push_back(pmcoreCallInstance);

      splitCallList.insert(std::pair<BdAddress, CallInstanceList> (deviceAddress, callsList));
      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSplitCallsRequest2PmCore(splitCallList, ccaToken);
   }

   handlePmResult(pmresult, ccaToken);

   splitCallMsg.vDestroy();
}

void CcaSplitCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSplitCallReqHandler::processMethodResponse entered"));

   PmCoreResponseData* splitCallResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("splitCallResponseMsg->_u64TokenId : %u", splitCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == splitCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSplitCallMethodResult oSplitCallMR;

//      oSplitCallMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oSplitCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oSplitCallMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(splitCallResponseMsg->_u64TokenId, oSplitCallMR);
      oSplitCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSplitCallReqHandler::processMethodResponse - Error for splitcall request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(splitCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
