/**
 * @file CcaSetRingtoneReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSetRingtoneReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSetRingtoneReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSetRingtoneReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSetRingtoneReqHandler::CcaSetRingtoneReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSetRingtoneReqHandler::CcaSetRingtoneReqHandler entered"));
}

void CcaSetRingtoneReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSetRingtoneReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSetRingtoneMethodStart setRingtoneMsg;

   getDataFromAmt(pInMsg, setRingtoneMsg);

   ETG_TRACE_USR4(("CcaSetRingtoneReqHandler::onMethodStart BdAddress : %s", setRingtoneMsg.sBdAddress.szValue));
   ETG_TRACE_USR4(("CcaSetRingtoneReqHandler::onMethodStart RingtoneID : %d", setRingtoneMsg.u8RingtoneID));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postSetRingtoneRequest2PmCore(
         setRingtoneMsg.sBdAddress.szValue, setRingtoneMsg.u8RingtoneID, ccaToken);

   handlePmResult(pmResult, ccaToken);
   setRingtoneMsg.vDestroy();
}

void CcaSetRingtoneReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSetRingtoneReqHandler::processMethodResponse entered"));

   PmCoreResponseData* setRintoneResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("setRintoneResponseMsg->_u64TokenId : %u", setRintoneResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == setRintoneResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSetRingtoneMethodResult oSetRingtoneMR;
      sendMethodResult(setRintoneResponseMsg->_u64TokenId, oSetRingtoneMR);
      oSetRingtoneMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSetRingtoneReqHandler::processMethodResponse - Error response for set ringtone request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(setRintoneResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
