/**
 * @file CcaSendDTMFReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSendDTMFReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSendDTMFReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSendDTMFReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSendDTMFReqHandler::CcaSendDTMFReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSendDTMFReqHandler::CcaSendDTMFReqHandler entered"));
}

CcaSendDTMFReqHandler::~CcaSendDTMFReqHandler()
{
   _actCallInstanceMap.clear();
}

void CcaSendDTMFReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSendDTMFReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSendDTMFMethodStart sendDTMFMsg;

   getDataFromAmt(pInMsg, sendDTMFMsg);

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if(sendDTMFMsg.sDTMFChar.szValue)
   {
      ETG_TRACE_USR4(("CcaSendDTMFReqHandler::onMethodStart CallInstance : %d", sendDTMFMsg.u16CallInstance));
      ETG_TRACE_USR4(("CcaSendDTMFReqHandler::onMethodStart DTMFChar : %s", sendDTMFMsg.sDTMFChar.szValue));

      BdAddress deviceAddress = "";
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

      _actCallInstanceMap.emplace_hint(_actCallInstanceMap.end(), ccaToken, sendDTMFMsg.u16CallInstance);

      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().sendDTMFRequest2PmCore(deviceAddress,
            sendDTMFMsg.sDTMFChar.szValue, ccaToken);
   }

   handlePmResult(pmresult, ccaToken);
   sendDTMFMsg.vDestroy();
}

void CcaSendDTMFReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSendDTMFReqHandler::processMethodResponse entered"));

   SendDTMFResponseMsg* sendDTMFResponseMsg = static_cast<SendDTMFResponseMsg*> (responseMsg);

   tU64 act = sendDTMFResponseMsg->_u64TokenId;
   auto it = _actCallInstanceMap.find(act);

   ETG_TRACE_USR4(("sendDTMFResponseMsg->_u64TokenId : %u", act));

   if(PM_RESULT_OK == sendDTMFResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSendDTMFMethodResult oSendDTMFMR;
      oSendDTMFMR.u16CallInstance = CALL_INSTANCE_DEFAULT;
      oSendDTMFMR.bCommandStatus = true;

      if (it != _actCallInstanceMap.end())
      {
         oSendDTMFMR.u16CallInstance = it->second;
         _actCallInstanceMap.erase(it);
      }

      sendMethodResult(sendDTMFResponseMsg->_u64TokenId, oSendDTMFMR);
      oSendDTMFMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSendDTMFReqHandler::processMethodResponse - Error response for sendDTMF request"));

      if (it != _actCallInstanceMap.end())
      {
         _actCallInstanceMap.erase(it);
      }

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(sendDTMFResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
