/**
 * @file CcaRejectCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaRejectCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaRejectCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaRejectCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaRejectCallReqHandler::CcaRejectCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaRejectCallReqHandler::CcaRejectCallReqHandler entered"));
}

void CcaRejectCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaRejectCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgRejectCallMethodStart rejectCallMsg;

   getDataFromAmt(pInMsg, rejectCallMsg);

   ETG_TRACE_USR4(("CcaRejectCallReqHandler::onMethodStart CallInstance : %d", rejectCallMsg.u16CallInstance));

   DeviceCallInstanceListMap rejectCallList;
   CallInstanceList callsList;
   callsList.push_back((CallInstance)rejectCallMsg.u16CallInstance);

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   rejectCallList.insert(std::pair<BdAddress, CallInstanceList> (deviceAddress, callsList));

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postHangupCallsRequest2PmCore(rejectCallList, ccaToken);
   handlePmResult(pmresult, ccaToken);

   rejectCallMsg.vDestroy();
}

void CcaRejectCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRejectCallReqHandler::processMethodResponse entered"));

   PmCoreResponseData* rejectCallResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("rejectCallResponseMsg->_u64TokenId : %u", rejectCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == rejectCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgRejectCallMethodResult oRejectCallMR;

//      oRejectCallMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oRejectCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oRejectCallMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(rejectCallResponseMsg->_u64TokenId, oRejectCallMR);
      oRejectCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaRejectCallReqHandler::processMethodResponse - Error for reject request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(rejectCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
