/**
 * @file CcaPlayRingtoneReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaPlayRingtoneReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaPlayRingtoneReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaPlayRingtoneReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaPlayRingtoneReqHandler::CcaPlayRingtoneReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaPlayRingtoneReqHandler::CcaPlayRingtoneReqHandler entered"));
}

void CcaPlayRingtoneReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaPlayRingtoneReqHandler::onMethodStart entered"));

   most_telfi_tclMsgPlayRingtoneMethodStart playRingtoneMsg;

   getDataFromAmt(pInMsg, playRingtoneMsg);

   ETG_TRACE_USR4(("CcaPlayRingtoneReqHandler::onMethodStart RingtoneID : %d", playRingtoneMsg.u8RingtoneID));
   ETG_TRACE_USR4(("CcaPlayRingtoneReqHandler::onMethodStart PlayCount : %d",
         playRingtoneMsg.u8PlayCount));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postPlayRingtoneRequest2PmCore(
         playRingtoneMsg.u8RingtoneID, playRingtoneMsg.u8PlayCount, ccaToken);

   handlePmResult(pmResult, ccaToken);
   playRingtoneMsg.vDestroy();
}

void CcaPlayRingtoneReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaPlayRingtoneReqHandler::processMethodResponse entered"));

   PmCoreResponseData* playRingtoneResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("playRingtoneResponseMsg->_u64TokenId : %u", playRingtoneResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == playRingtoneResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgPlayRingtoneMethodResult playRingtoneMethodResult;
      sendMethodResult(playRingtoneResponseMsg->_u64TokenId, playRingtoneMethodResult);
      playRingtoneMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaPlayRingtoneReqHandler::processMethodResponse - Error response for play ringtone request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(playRingtoneResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
