/**
 * @file CcaDialReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaDialReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaDialReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaDialReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaDialReqHandler::CcaDialReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaDialReqHandler::CcaDialReqHandler entered"));
}

void CcaDialReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaDialReqHandler::onMethodStart entered"));

   most_telfi_tclMsgDialMethodStart dialMsg;

   getDataFromAmt(pInMsg, dialMsg);

   PmResult pmResult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if(dialMsg.sTelephoneNumber.szValue)
   {
      ETG_TRACE_USR4(("CcaDialReqHandler::onMethodStart TelephoneNumber : %s", dialMsg.sTelephoneNumber.szValue));
      ETG_TRACE_USR4(("CcaDialReqHandler::onMethodStart ECNRSetting : %d",
            dialMsg.e8EchoCancellationNoiseReductionSetting.enType));

      TelephoneNumber telephoneNumber(dialMsg.sTelephoneNumber.szValue);

      DialInfo dialInfo(telephoneNumber, "", "", DEFAULT_CALLERID);

      BdAddress deviceAddress = "";
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
      pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postDialRequest2PmCore(deviceAddress, dialInfo, ccaToken);
   }

   handlePmResult(pmResult, ccaToken);
   dialMsg.vDestroy();
}

void CcaDialReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaDialReqHandler::processMethodResponse entered"));

   DialResponseMsg* dialResponseMsg = static_cast<DialResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("dialResponseMsg->_u64TokenId : %u", dialResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == dialResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgDialMethodResult oDialMR;

//      oDialMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oDialMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oDialMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(dialResponseMsg->_u64TokenId, oDialMR);
      oDialMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaDialReqHandler::processMethodResponse - Error response for dial request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(dialResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
