/**
 * @file CcaActivateExternalVRReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaActivateExternalVRReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaActivateExternalVRReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaActivateExternalVRReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaActivateExternalVRReqHandler::CcaActivateExternalVRReqHandler(ahl_tclBaseOneThreadService* pService) :
      CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaActivateExternalVRReqHandler::CcaActivateExternalVRReqHandler entered"));
}

void CcaActivateExternalVRReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaActivateExternalVRReqHandler::onMethodStart entered"));

   most_telfi_tclMsgActivateExternalVRMethodStart activateExternalVRMsg;

   getDataFromAmt(pInMsg, activateExternalVRMsg);

   ETG_TRACE_USR4(("CcaActivateExternalVRReqHandler::BdAddress %s", activateExternalVRMsg.sBdAddress.szValue));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postActivateExternalVRRequest2PmCore(
         activateExternalVRMsg.sBdAddress.szValue, ccaToken);

   handlePmResult(pmResult, ccaToken);

   activateExternalVRMsg.vDestroy();
}

void CcaActivateExternalVRReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaActivateExternalVRReqHandler::processMethodResponse entered"));

   PmCoreResponseData* activateExternalVRResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("activateExternalVRResponseMsg->_u64TokenId: %u", activateExternalVRResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == activateExternalVRResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgActivateExternalVRMethodResult activateExternalVRMethodResult;

      sendMethodResult(activateExternalVRResponseMsg->_u64TokenId, activateExternalVRMethodResult);

      activateExternalVRMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaActivateExternalVRReqHandler::processMethodResponse - Error response for"
            " activate external VR request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(activateExternalVRResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
