/**
 * @file CcaIgnoreCallReqHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaIgnoreCallReqHandler class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef CcaIgnoreCallReqHandler_h
#define CcaIgnoreCallReqHandler_h

#include "CcaMethod.h"

/*
 * This is the handler class for IgnoreCall CCA message MOST_TELFI_C_U16_IGNORECALL
 * 
 */
class CcaIgnoreCallReqHandler final: public CcaMethod
{

public:

   /**
    * Actual processing of the CCA message takes place here and forward
    * request to IpcWrapper. From IpcWrapper request is posted to PM CORE CPP
    *
    * @param[in] amt_tclServiceData* - Pointer to the CCA message data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken) override;

   /**
    * Process the response data from the core layer and update the requested
    * clients
    *
    * @param[in]  PmCoreResponseData* - Pointer to the response data from CPP layer
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processMethodResponse(PmCoreResponseData* pInMsg) override;

   /**
    * Constructor of CcaIgnoreCallReqHandler class
    *
    * @param[in] ahl_tclBaseOneThreadService* pServer - Pointer to the PM CCA service
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CcaIgnoreCallReqHandler(ahl_tclBaseOneThreadService* pService);

   /**
    * Destructor of CcaIgnoreCallReqHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~CcaIgnoreCallReqHandler()
   {

   }

};

#endif // CcaIgnoreCallReqHandler_h
