/**
 * @file PmAppCcaServer.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmAppCcaServer class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for PmAppCcaServer class
 *
 * @ingroup IpcWrapper
 */

#ifndef PmAppCcaServer_h
#define PmAppCcaServer_h

#include "AhlApp.h"
#include "AhlService.h"
#include "CcaMessageHandler.h"

/*
 * This class instantiates the CCA framework related classes and the base CCA
 * Message handler class
 *
 */
class PmAppCcaServer
{

public:

   /**
    * Returns the instance of CcaMessageHandler class which is instantiated in this class
    *
    * @param[in]
    * @param[out] CcaMessageHandler* pointer to CCA Message handler class
    * @param[in,out]
    *
    * @return
    *
    */
   CcaMessageHandler* getCcaMsgHandler();

   /**
    * Returns the instance of AhlApp class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return AhlApp - pointer of cca framework ahl pm application
    *
    */
   AhlApp* getPmApplication();

   /**
    * Instantiates the CCA server instance of PM App
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void setServiceAvailable(bool availability = true);

   /**
    * Constructor of PmAppCcaServer class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PmAppCcaServer();

   /**
    * Destructor of PmAppCcaServer class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~PmAppCcaServer();

   /**
    * Copy constructor of PmAppCcaServer class
    *
    * @param[in] PmAppCcaServer& - Reference to PmAppCcaServer
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PmAppCcaServer(const PmAppCcaServer& );

   /**
    * Assignment operator of PmAppCcaServer class
    *
    * @param[in] PmAppCcaServer& - Reference to PmAppCcaServer
    * @param[out] 
    * @param[in,out]
    *
    * @return PmAppCcaServer& - Reference to PmAppCcaServer
    *
    */
   PmAppCcaServer& operator=(const PmAppCcaServer& );

private:

   AhlApp* _pAhlApp; /**< Pointer to the AhlApp class */

   AhlService* _pAhlService;  /**< Pointer to the AhlService class */

   CcaMessageHandler* _pCcaMsgHandler; /**< Pointer to the CcaMessageHandler class */
};

#endif // PmAppCcaServer_h
