/**
 * @file PhoneBookRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PhoneBookRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for PhoneBookRequestIf class
 *
 * @ingroup IpcWrapper
 */

#include "PhoneBookRequestIf.h"
#include "PhoneCallManager.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/clienthandlers", PhoneBookRequestIf, Info);

PhoneBookRequestIf::PhoneBookRequestIf()
:IPhoneBookRequestIf(false), _phoneBookCallBackIf(nullptr)
{
   LOG_INFO(("PhoneBookRequestIf::PhoneBookRequestIf() entered"));

   createProxy("mostPbkFiPort");
}

PhoneBookRequestIf::~PhoneBookRequestIf()
{
   destroyProxy();
}

void PhoneBookRequestIf::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   LOG_INFO("PhoneBookRequestIf::onAvailable() entered");

   if ((_phoneBookFiProxy.get()) && (proxy == _phoneBookFiProxy))
   {
      _serviceAvailability = true;
      DeviceDetailsListHandler::getInstance().checkPendingQueryContactsList();
   }
   else
   {
      LOG_ERROR("Undesirable proxy");
   }
}

void PhoneBookRequestIf::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   LOG_INFO("PhoneBookRequestIf::onUnavailable() entered");

   if ((_phoneBookFiProxy.get()) && (proxy == _phoneBookFiProxy))
   {
      _serviceAvailability = false;
   }
   else
   {
      LOG_ERROR("Undesirable proxy");
   }
}

void PhoneBookRequestIf::createProxy(const std::string portName)
{
   LOG_INFO("PhoneBookRequestIf::createProxy entered");

   if (!(portName.empty()))
   {
      _phoneBookFiProxy = MOST_PhonBk_FIProxy::createProxy(portName, *this);
   }
}

void PhoneBookRequestIf::destroyProxy()
{
   if (_phoneBookFiProxy.get())
   {
      _phoneBookFiProxy.reset();
   }
}

void PhoneBookRequestIf::setPhoneBookCallBackIf(IPhoneBookCallBackIf* phoneBookCallBackIf)
{
   LOG_INFO("PhoneBookRequestIf::setIPhoneBookCallBackIf entered");
   if (phoneBookCallBackIf)
   {
      _phoneBookCallBackIf = phoneBookCallBackIf;
      _phoneBookCallBackIf->setPhoneBookFiProxy(_phoneBookFiProxy);
   }
}

void PhoneBookRequestIf::registerProperties()
{
   LOG_INFO("PhoneBookRequestIf::registerProperties() entered");

   // As of now Phone call manager does not listen to any properties from Phonebook component.
}

void PhoneBookRequestIf::deregisterProperties()
{
   LOG_INFO("PhoneBookRequestIf::deregisterProperties() entered");

   // As of now Phone call manager does not listen to any properties from Phonebook component.
}

act_t PhoneBookRequestIf::searchPhoneBook(const uint8 deviceHandle, const ::fi_basetypes_most::T_String phoneNumber)
{
   LOG_INFO("searchPhoneBook() entered with deviceHandle: %u", deviceHandle);
   LOG_INFO("searchPhoneBook() entered with phoneNumber: %s", phoneNumber.c_str());

   act_t act = DEFAULT_ACT;
   if (_serviceAvailability && (_phoneBookFiProxy.get()) && (_phoneBookCallBackIf))
   {
      if (PM_DEVICEHANDLE_ZERO != deviceHandle)
      {
         LOG_INFO("PhoneBookRequestIf::searchPhoneBook");
         // In the below request, "sEmailAddress" is set to EMPTY string.
         // Since as of now, PM App is not dealing with MailIDs.

         act = _phoneBookFiProxy->sendSearchPhoneBookStart(*_phoneBookCallBackIf, deviceHandle, phoneNumber, "");
      }
   }

   return act;
}

act_t PhoneBookRequestIf::searchPhoneBook(const std::string deviceAddress, const std::string phoneNumber)
{
   LOG_INFO("searchPhoneBook() entered with deviceAddress: %s", deviceAddress.c_str());
   LOG_INFO("searchPhoneBook() entered with phoneNumber: %s", phoneNumber.c_str());
   act_t act = DEFAULT_ACT;

   return act;
}
} // namespace pmapp
} // namespace bosch
} // namespace com
