/**
 * @file MediaPlayerRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MediaPlayerRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for MediaPlayerRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef MediaPlayerRequestIf_h
#define MediaPlayerRequestIf_h

#include "MediaPlayerCallBackIf.h"
#include "ICreateDestroyProxy.h"
#include "IMediaPlayerRequestIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class MediaPlayerRequestIf final
: public asf::core::ServiceAvailableIF
  , public ICreateDestroyProxy
  , public IMediaPlayerRequestIf
  {
  public:

   /**
    * Constructor of MediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   MediaPlayerRequestIf();

   /**
    * Destructor of MediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~MediaPlayerRequestIf();

   /**
    * Member function Overridden from IMediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setMediaPlayerCallBackIf(IMediaPlayerCallBackIf*) override;

  protected:
   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void createProxy(const std::string portName) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void destroyProxy() override;

   /**
    * Member function Overridden from IMediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() override;

   /**
    * Member function Overridden from IMediaPlayerRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() override;

  private:
   MplayMediaPlayerFIProxy _mplayMediaPlayerFIProxy; /**< Instance of the MOST_PhonBk_FIProxy class >*/
   IMediaPlayerCallBackIf* _mediaPlayerCallBackIf;

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
  };

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //MediaPlayerRequestIf_h
