/**
 * @file MediaPlayerCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MediaPlayerCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for MediaPlayerCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef MediaPlayerCallBackIf_h
#define MediaPlayerCallBackIf_h

#include "asf/core/Logger.h"
#include "IMediaPlayerCallBackIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class MediaPlayerCallBackIf final
: public IMediaPlayerCallBackIf
  {
  public:

   /**
    * Constructor of MediaPlayerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   MediaPlayerCallBackIf();

   /**
    * Destructor of MediaPlayerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~MediaPlayerCallBackIf();

   /**
    * Member function Overridden from IMediaPlayerCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setMediaPlayerFiProxy(MplayMediaPlayerFIProxy mplayMediaPlayerFIProxy) override;

  protected:

  /**
   * Callback method for onReadyToPlayError Signal
   *
   * @param[in] proxy - A reference to Mplay_MediaPlayer_FIProxy
   * @param[in] error - ReadyToPlayError status
   * @param[out]
   * @param[in,out]
   *
   * @return void
   */
   virtual void onReadyToPlayError(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ReadyToPlayError >& error) override;

   /**
   * Callback method for onReadyToPlayStatus Signal
   *
   * @param[in] proxy - A reference to Mplay_MediaPlayer_FIProxy
   * @param[in] status - ReadyToPlayStatus
   * @param[out]
   * @param[in,out]
   *
   * @return void
   */
   virtual void onReadyToPlayStatus(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ReadyToPlayStatus >& status) override;

  private:
   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
  };

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //MediaPlayerCallBackIf_h
