/**
 * @file BmAppRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the BmAppRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for BmAppRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef BmAppRequestIf_h
#define BmAppRequestIf_h

#include "BmAppCallBackIf.h"
#include "ICreateDestroyProxy.h"
#include "IBmAppRequestIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class BmAppRequestIf final
: public asf::core::ServiceAvailableIF
  , public ICreateDestroyProxy
  , public IBmAppRequestIf
  {
  public:

   /**
    * Constructor of BmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   BmAppRequestIf();

   /**
    * Destructor of BmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~BmAppRequestIf();

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setBmAppCallBackIf(IBmAppCallBackIf*) override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setBTProfilesUsage(const uint8 deviceHandle, const bool profileUsageInfo,
         const BTProfileUsageType profileUsageType) override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setBTProfilesUsage(const std::string deviceAddress, const bool profileUsageInfo,
         const BTProfileUsageType profileUsageType) override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setPrimaryDevice(const pmcore::BdAddressList& activeDevicesList) override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerDeviceListExtendedProperty() override;

  protected:
   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void createProxy(const std::string) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void destroyProxy() override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() override;

   /**
    * Member function Overridden from IBmAppRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() override;

  private:

   /**
    * This function is used to send the BT Profile usage info to the client
    *
    * @param[in]  deviceHandle - Device handle
    *             oBTProfUsageInfo - Bt Profile usage info
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void sendBTProfilesUsage(const uint8 deviceHandle, const T_BTProfilesUsageInfo oBTProfUsageInfo);

   MostBTSetFiProxy _btSetFIProxy; /**< Instance of the MOST_BTSet_FIProxy class >*/
   IBmAppCallBackIf* _bmAppCallBackIf;

   // This vector is used to avoid the duplicate updates.
   std::vector<uint8> _hfpProfileActiveDevHandles;

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
  };

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //BmAppRequestIf_h
