/**
 * @file StreamMessage.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the StreamMessage class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef StreamMessage_h
#define StreamMessage_h

#include "amt_fw.h"

/**
 * This class takes care of converting the ASF based message format to a CCA message format
 */
class StreamMessage : public amt_tclBaseMessage
{
public:

   /**
    * Constructor of StreamMessage class
    *
    * @param[in] tU8* - pointer to the stream data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   StreamMessage(const tU8* pStreamData);

   /**
    * Destructor of StreamMessage class
    *
    * @param[in] tU8* - pointer to the stream data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~StreamMessage();

private:

   /**
    * Constructor of StreamMessage class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   StreamMessage();
};

#endif // StreamMessage_h
