/**
 * @file AhlService.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AhlService class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details The PM APP CCA server framework class is defined here.
 *
 * @ingroup IpcWrapper
 */

#ifndef AhlService_h
#define AhlService_h

#include "asf/core/Logger.h"

#include "ahl_fw.h"

/**
 * The class defines the AhlService class through which the CCA interfaces are
 * routed to phone call manager
 */
class AhlService final: public ahl_tclBaseOneThreadService
{
public:

   /**
    * Constructor of AhlService class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AhlService();  // declaration without implementation!

   /**
    * Constructor of AhlService class
    *
    * @param[in] ahl_tclBaseOneThreadApp* - Instance of the AhlApp class
    *            tU16 - Telephone CCA service ID - CCA_C_U16_SRV_FB_TELEPHONE
    *            tU16 - Telephone FI major version - MOST_TELFI_C_U16_SERVICE_MAJORVERSION
    *            tU16 - Telephone FI minor version - MOST_TELFI_C_U16_SERVICE_MINORVERSION
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AhlService(ahl_tclBaseOneThreadApp* app, tU16 serviceId, tU16 majorVersion, tU16 minorVersion);

   /**
    * Destructor of AhlService class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~AhlService();

   void setPmCcaServiceAvailability(bool availability = false);

private:

   /**
    * The AIL/AHL framework dispatches the message to the addressed AHL service
    * and the message finally reaches the AhlService::vMyDispatchMessage() method
    *
    * @param[in] amt_tclServiceData* Message in the CCA format
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void vMyDispatchMessage(amt_tclServiceData* pServiceDataMessage) override;

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member

};

#endif // AhlService_h
