/* *
 * @file PmRingtoneHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmRingtoneHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#include "PmRingtoneHandlerSm.h"

/*! \file Implementation of the state machine 'PmRingtoneHandlerSm'
*/




PmRingtoneHandlerSm::PmRingtoneHandlerSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceUserAction(this),
ifaceUserAction_OCB(sc_null),
ifaceSmHandler(this),
ifaceSmHandler_OCB(sc_null),
ifaceAudioManagerRequest(this),
ifaceAudioManagerRequest_OCB(sc_null),
ifaceAudioManagerResponse(this),
isRunningCycle(false)
{
}

PmRingtoneHandlerSm::~PmRingtoneHandlerSm()
{
}


using namespace pmringtonehandlersm_events;

SctEvent* PmRingtoneHandlerSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void PmRingtoneHandlerSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_UserAction_PLAY_RINGTONE:
		case SCI_UserAction_STOP_RINGTONE:
		case SCI_UserAction_MUTE_RINGTONE:
		case SCI_UserAction_UNMUTE_RINGTONE:
		case SCI_UserAction_PAUSE_RINGTONE:
		case SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE:
		case SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE:
		case SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE:
		{
			ifaceUserAction.dispatch_event(event);
			break;
		}
		case SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE:
		case SCI_SmHandler_SWITCH_TO_ACTIVE:
		case SCI_SmHandler_MOVE_TO_IDLE:
		{
			ifaceSmHandler.dispatch_event(event);
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED:
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED:
		case SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_STOP_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED:
		{
			ifaceAudioManagerResponse.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void PmRingtoneHandlerSm::SCI_UserAction::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_UserAction_PLAY_RINGTONE:
		{
			internal_raise_pLAY_RINGTONE();
			break;
		}
		case SCI_UserAction_STOP_RINGTONE:
		{
			SctEvent_SCI_UserAction_STOP_RINGTONE * e = static_cast<SctEvent_SCI_UserAction_STOP_RINGTONE*>(event);
			if(e != 0) {
				internal_raise_sTOP_RINGTONE(e->value);
			}
			break;
		}
		case SCI_UserAction_MUTE_RINGTONE:
		{
			internal_raise_mUTE_RINGTONE();
			break;
		}
		case SCI_UserAction_UNMUTE_RINGTONE:
		{
			internal_raise_uNMUTE_RINGTONE();
			break;
		}
		case SCI_UserAction_PAUSE_RINGTONE:
		{
			internal_raise_pAUSE_RINGTONE();
			break;
		}
		case SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE:
		{
			internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
			break;
		}
		case SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE:
		{
			internal_raise_wAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE();
			break;
		}
		case SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE:
		{
			internal_raise_wAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE();
			break;
		}
		default:
			break;
	}
}
void PmRingtoneHandlerSm::SCI_SmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE:
		{
			internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
			break;
		}
		case SCI_SmHandler_SWITCH_TO_ACTIVE:
		{
			internal_raise_sWITCH_TO_ACTIVE();
			break;
		}
		case SCI_SmHandler_MOVE_TO_IDLE:
		{
			internal_raise_mOVE_TO_IDLE();
			break;
		}
		default:
			break;
	}
}
void PmRingtoneHandlerSm::SCI_AudioManagerRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED:
		{
			internal_raise_rINGTONE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED:
		{
			internal_raise_rINGTONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS:
		{
			internal_raise_pLAY_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE:
		{
			internal_raise_pLAY_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS:
		{
			internal_raise_pAUSE_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE:
		{
			internal_raise_pAUSE_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS:
		{
			internal_raise_sTOP_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_STOP_AUDIO_FAILURE:
		{
			internal_raise_sTOP_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED:
		{
			internal_raise_rINGTONE_CHANNEL_RELEASED();
			break;
		}
		default:
			break;
	}
}


void PmRingtoneHandlerSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = PmRingtoneHandlerSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
	/* Default init sequence for statechart PmRingtoneHandlerSm */
	ifaceUserAction.ringtoneId = 0;
	ifaceUserAction.playCount = 0;
}

void PmRingtoneHandlerSm::enter()
{
	/* Default enter sequence for statechart PmRingtoneHandlerSm */
	enseq_Main_region_default();
}

void PmRingtoneHandlerSm::exit()
{
	/* Default exit sequence for statechart PmRingtoneHandlerSm */
	exseq_Main_region();
}

sc_boolean PmRingtoneHandlerSm::isActive() const
{
	return stateConfVector[0] != PmRingtoneHandlerSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean PmRingtoneHandlerSm::isFinal() const
{
   return false;}

void PmRingtoneHandlerSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case Main_region_RingtoneHandler_ringtonehandler_region_Idle :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_Idle_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_react(true);
					break;
				}
				case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio :
				{
					Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void PmRingtoneHandlerSm::clearInEvents()
{
	ifaceUserAction.PLAY_RINGTONE_raised = false;
	ifaceUserAction.STOP_RINGTONE_raised = false;
	ifaceUserAction.MUTE_RINGTONE_raised = false;
	ifaceUserAction.UNMUTE_RINGTONE_raised = false;
	ifaceUserAction.PAUSE_RINGTONE_raised = false;
	ifaceUserAction.WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised = false;
	ifaceUserAction.WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE_raised = false;
	ifaceUserAction.WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE_raised = false;
	ifaceSmHandler.WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised = false;
	ifaceSmHandler.SWITCH_TO_ACTIVE_raised = false;
	ifaceSmHandler.MOVE_TO_IDLE_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_GRANTED_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_DENIED_raised = false;
	ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.PLAY_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.PAUSE_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.STOP_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_RELEASED_raised = false;
}

void PmRingtoneHandlerSm::clearOutEvents()
{
}


sc_boolean PmRingtoneHandlerSm::isStateActive(PmRingtoneHandlerSmStates state) const
{
	switch (state)
	{
		case Main_region_RingtoneHandler : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER] >= Main_region_RingtoneHandler
				&& stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER] <= Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio);
		case Main_region_RingtoneHandler_ringtonehandler_region_Idle : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_IDLE] == Main_region_RingtoneHandler_ringtonehandler_region_Idle
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE] >= Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone
				&& stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE] <= Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_REQUESTSTREAMING] == Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_STREAMINGSTARTED] == Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_STREAMINGPAUSED] == Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_REPLAY] == Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_WAITFORPLAYRESPTOREPLAY] == Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_WAITFORRINGTONECHANNELACQUISITION] == Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE] >= Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone
				&& stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE] <= Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio);
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_PLAYAFTERSTOPAUDIORESPONSE] == Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_STOPAFTERSTOPAUDIORESPONSE] == Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse
			);
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_REQUESTSTOPAUDIO] == Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio
			);
		default: return false;
	}
}

PmRingtoneHandlerSm::SCI_UserAction* PmRingtoneHandlerSm::getSCI_UserAction()
{
	return &ifaceUserAction;
}
/* Functions for event PLAY_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_pLAY_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_PLAY_RINGTONE(SCI_UserAction_PLAY_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_pLAY_RINGTONE()
{
	PLAY_RINGTONE_raised = true;
}
/* Functions for event STOP_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_sTOP_RINGTONE(pmcore::PmCoreIfMessage_StopRingtoneRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_STOP_RINGTONE(SCI_UserAction_STOP_RINGTONE, value));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_sTOP_RINGTONE(pmcore::PmCoreIfMessage_StopRingtoneRequest * value)
{
	STOP_RINGTONE_value = value;
	STOP_RINGTONE_raised = true;
}
/* Functions for event MUTE_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_mUTE_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_MUTE_RINGTONE(SCI_UserAction_MUTE_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_mUTE_RINGTONE()
{
	MUTE_RINGTONE_raised = true;
}
/* Functions for event UNMUTE_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_uNMUTE_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_UNMUTE_RINGTONE(SCI_UserAction_UNMUTE_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_uNMUTE_RINGTONE()
{
	UNMUTE_RINGTONE_raised = true;
}
/* Functions for event PAUSE_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_pAUSE_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_PAUSE_RINGTONE(SCI_UserAction_PAUSE_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_pAUSE_RINGTONE()
{
	PAUSE_RINGTONE_raised = true;
}
/* Functions for event WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE(SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE()
{
	WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised = true;
}
/* Functions for event WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_wAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE(SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_wAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE()
{
	WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE_raised = true;
}
/* Functions for event WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE in interface SCI_UserAction */
void PmRingtoneHandlerSm::SCI_UserAction::raise_wAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE(SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_UserAction::internal_raise_wAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE()
{
	WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE_raised = true;
}
pmcore::RingtoneId PmRingtoneHandlerSm::SCI_UserAction::get_ringtoneId() const
{
	return ringtoneId;
}

void PmRingtoneHandlerSm::SCI_UserAction::set_ringtoneId(pmcore::RingtoneId value)
{
	ringtoneId = value;
}

pmcore::PlayCount PmRingtoneHandlerSm::SCI_UserAction::get_playCount() const
{
	return playCount;
}

void PmRingtoneHandlerSm::SCI_UserAction::set_playCount(pmcore::PlayCount value)
{
	playCount = value;
}

void PmRingtoneHandlerSm::setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback)
{
	ifaceUserAction_OCB = operationCallback;
}
PmRingtoneHandlerSm::SCI_SmHandler* PmRingtoneHandlerSm::getSCI_SmHandler()
{
	return &ifaceSmHandler;
}
/* Functions for event WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE in interface SCI_SmHandler */
void PmRingtoneHandlerSm::SCI_SmHandler::raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE(SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_SmHandler::internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE()
{
	WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised = true;
}
/* Functions for event SWITCH_TO_ACTIVE in interface SCI_SmHandler */
void PmRingtoneHandlerSm::SCI_SmHandler::raise_sWITCH_TO_ACTIVE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE(SCI_SmHandler_SWITCH_TO_ACTIVE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_SmHandler::internal_raise_sWITCH_TO_ACTIVE()
{
	SWITCH_TO_ACTIVE_raised = true;
}
/* Functions for event MOVE_TO_IDLE in interface SCI_SmHandler */
void PmRingtoneHandlerSm::SCI_SmHandler::raise_mOVE_TO_IDLE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_SmHandler_MOVE_TO_IDLE(SCI_SmHandler_MOVE_TO_IDLE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_SmHandler::internal_raise_mOVE_TO_IDLE()
{
	MOVE_TO_IDLE_raised = true;
}
void PmRingtoneHandlerSm::setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback)
{
	ifaceSmHandler_OCB = operationCallback;
}
PmRingtoneHandlerSm::SCI_AudioManagerRequest* PmRingtoneHandlerSm::getSCI_AudioManagerRequest()
{
	return &ifaceAudioManagerRequest;
}
void PmRingtoneHandlerSm::setSCI_AudioManagerRequest_OCB(SCI_AudioManagerRequest_OCB* operationCallback)
{
	ifaceAudioManagerRequest_OCB = operationCallback;
}
PmRingtoneHandlerSm::SCI_AudioManagerResponse* PmRingtoneHandlerSm::getSCI_AudioManagerResponse()
{
	return &ifaceAudioManagerResponse;
}
/* Functions for event RINGTONE_CHANNEL_GRANTED in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_GRANTED()
{
	RINGTONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event RINGTONE_CHANNEL_DENIED in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_DENIED()
{
	RINGTONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event PLAY_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_pLAY_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS(SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_pLAY_AUDIO_SUCCESS()
{
	PLAY_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PLAY_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_pLAY_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE(SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_pLAY_AUDIO_FAILURE()
{
	PLAY_AUDIO_FAILURE_raised = true;
}
/* Functions for event PAUSE_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_pAUSE_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS(SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_pAUSE_AUDIO_SUCCESS()
{
	PAUSE_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PAUSE_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_pAUSE_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE(SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_pAUSE_AUDIO_FAILURE()
{
	PAUSE_AUDIO_FAILURE_raised = true;
}
/* Functions for event STOP_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_sTOP_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS(SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_sTOP_AUDIO_SUCCESS()
{
	STOP_AUDIO_SUCCESS_raised = true;
}
/* Functions for event STOP_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_sTOP_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE(SCI_AudioManagerResponse_STOP_AUDIO_FAILURE));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_sTOP_AUDIO_FAILURE()
{
	STOP_AUDIO_FAILURE_raised = true;
}
/* Functions for event RINGTONE_CHANNEL_RELEASED in interface SCI_AudioManagerResponse */
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_RELEASED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED));
	parent->runCycle();
}
void PmRingtoneHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_RELEASED()
{
	RINGTONE_CHANNEL_RELEASED_raised = true;
}

void PmRingtoneHandlerSm::setTraceObserver(ysc::TraceObserver<PmRingtoneHandlerSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<PmRingtoneHandlerSm::PmRingtoneHandlerSmStates>* PmRingtoneHandlerSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

void PmRingtoneHandlerSm::effect_Main_region_RingtoneHandler_tr2()
{
	exseq_Main_region_RingtoneHandler();
	ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_NOT_PLAYING);
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle_default();
	react();
}

void PmRingtoneHandlerSm::effect_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_tr3()
{
	exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone();
	react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
}

void PmRingtoneHandlerSm::effect_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_tr0()
{
	exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
	react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
}

/* Entry action for state 'RequestStreaming'. */
void PmRingtoneHandlerSm::enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming()
{
	/* Entry action for state 'RequestStreaming'. */
	ifaceAudioManagerRequest_OCB->playRingtone();
	ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_STARTING_TO_PLAY);
}

/* Entry action for state 'StreamingStarted'. */
void PmRingtoneHandlerSm::enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted()
{
	/* Entry action for state 'StreamingStarted'. */
	ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_PLAYING);
}

/* Entry action for state 'WaitForRingtoneChannelAcquisition'. */
void PmRingtoneHandlerSm::enact_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition()
{
	/* Entry action for state 'WaitForRingtoneChannelAcquisition'. */
	ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_PREPARING_CH);
}

/* Entry action for state 'StoppingRingtone'. */
void PmRingtoneHandlerSm::enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone()
{
	/* Entry action for state 'StoppingRingtone'. */
	ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_STOPPING);
}

/* Entry action for state 'RequestStopAudio'. */
void PmRingtoneHandlerSm::enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio()
{
	/* Entry action for state 'RequestStopAudio'. */
	ifaceUserAction_OCB->stopRingtone(ifaceUserAction.STOP_RINGTONE_value);
}

/* 'default' enter sequence for state RingtoneHandler */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_default()
{
	/* 'default' enter sequence for state RingtoneHandler */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_default();
}

/* 'default' enter sequence for state Idle */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle_default()
{
	/* 'default' enter sequence for state Idle */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_Idle);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_Idle;
	stateConfVectorPosition = 0;
}

/* 'EntryToWaitForPlayRespToReplay' enter sequence for state PlayRingtone */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_EntryToWaitForPlayRespToReplay()
{
	/* 'EntryToWaitForPlayRespToReplay' enter sequence for state PlayRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay();
}

/* 'default' enter sequence for state PlayRingtone */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_default()
{
	/* 'default' enter sequence for state PlayRingtone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_default();
}

/* 'default' enter sequence for state RequestStreaming */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_default()
{
	/* 'default' enter sequence for state RequestStreaming */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStarted */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_default()
{
	/* 'default' enter sequence for state StreamingStarted */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingPaused */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_default()
{
	/* 'default' enter sequence for state StreamingPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Replay */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_default()
{
	/* 'default' enter sequence for state Replay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPlayRespToReplay */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_default()
{
	/* 'default' enter sequence for state WaitForPlayRespToReplay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRingtoneChannelAcquisition */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_default()
{
	/* 'default' enter sequence for state WaitForRingtoneChannelAcquisition */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition;
	stateConfVectorPosition = 0;
}

/* 'PlayAfterStopResp' enter sequence for state StoppingRingtone */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_PlayAfterStopResp()
{
	/* 'PlayAfterStopResp' enter sequence for state StoppingRingtone */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp();
}

/* 'default' enter sequence for state StoppingRingtone */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_default()
{
	/* 'default' enter sequence for state StoppingRingtone */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone);
	}
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_default();
}

/* 'default' enter sequence for state PlayAfterStopAudioResponse */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default()
{
	/* 'default' enter sequence for state PlayAfterStopAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterStopAudioResponse */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_default()
{
	/* 'default' enter sequence for state StopAfterStopAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStopAudio */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_default()
{
	/* 'default' enter sequence for state RequestStopAudio */
	enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio);
	}
	stateConfVector[0] = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region Main_region */
void PmRingtoneHandlerSm::enseq_Main_region_default()
{
	/* 'default' enter sequence for region Main_region */
	react_Main_region__entry_Default();
}

/* 'default' enter sequence for region ringtonehandler_region */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_default()
{
	/* 'default' enter sequence for region ringtonehandler_region */
	react_Main_region_RingtoneHandler_ringtonehandler_region__entry_Default();
}

/* 'default' enter sequence for region playringtone_region */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_default()
{
	/* 'default' enter sequence for region playringtone_region */
	react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region__entry_Default();
}

/* 'EntryToWaitForPlayRespToReplay' enter sequence for region playringtone_region */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay()
{
	/* 'EntryToWaitForPlayRespToReplay' enter sequence for region playringtone_region */
	react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay();
}

/* 'default' enter sequence for region StoppingRingtone_region */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_default()
{
	/* 'default' enter sequence for region StoppingRingtone_region */
	react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region__entry_Default();
}

/* 'PlayAfterStopResp' enter sequence for region StoppingRingtone_region */
void PmRingtoneHandlerSm::enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp()
{
	/* 'PlayAfterStopResp' enter sequence for region StoppingRingtone_region */
	react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp();
}

/* Default exit sequence for state RingtoneHandler */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler()
{
	/* Default exit sequence for state RingtoneHandler */
	exseq_Main_region_RingtoneHandler_ringtonehandler_region();
}

/* Default exit sequence for state Idle */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle()
{
	/* Default exit sequence for state Idle */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayRingtone */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone()
{
	/* Default exit sequence for state PlayRingtone */
	exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region();
}

/* Default exit sequence for state RequestStreaming */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming()
{
	/* Default exit sequence for state RequestStreaming */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStarted */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted()
{
	/* Default exit sequence for state StreamingStarted */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingPaused */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused()
{
	/* Default exit sequence for state StreamingPaused */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Replay */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay()
{
	/* Default exit sequence for state Replay */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPlayRespToReplay */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay()
{
	/* Default exit sequence for state WaitForPlayRespToReplay */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRingtoneChannelAcquisition */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition()
{
	/* Default exit sequence for state WaitForRingtoneChannelAcquisition */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StoppingRingtone */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone()
{
	/* Default exit sequence for state StoppingRingtone */
	exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region();
}

/* Default exit sequence for state PlayAfterStopAudioResponse */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse()
{
	/* Default exit sequence for state PlayAfterStopAudioResponse */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterStopAudioResponse */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse()
{
	/* Default exit sequence for state StopAfterStopAudioResponse */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStopAudio */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio()
{
	/* Default exit sequence for state RequestStopAudio */
	stateConfVector[0] = PmRingtoneHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region Main_region */
void PmRingtoneHandlerSm::exseq_Main_region()
{
	/* Default exit sequence for region Main_region */
	/* Handle exit of all possible states (of PmRingtoneHandlerSm.Main_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RingtoneHandler_ringtonehandler_region_Idle :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ringtonehandler_region */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region()
{
	/* Default exit sequence for region ringtonehandler_region */
	/* Handle exit of all possible states (of PmRingtoneHandlerSm.Main_region.RingtoneHandler.ringtonehandler_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RingtoneHandler_ringtonehandler_region_Idle :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region playringtone_region */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region()
{
	/* Default exit sequence for region playringtone_region */
	/* Handle exit of all possible states (of PmRingtoneHandlerSm.Main_region.RingtoneHandler.ringtonehandler_region.PlayRingtone.playringtone_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StoppingRingtone_region */
void PmRingtoneHandlerSm::exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region()
{
	/* Default exit sequence for region StoppingRingtone_region */
	/* Handle exit of all possible states (of PmRingtoneHandlerSm.Main_region.RingtoneHandler.ringtonehandler_region.StoppingRingtone.StoppingRingtone_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
			break;
		}
		case Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio :
		{
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
			break;
		}
		default: break;
	}
}

/* Default react sequence for initial entry  */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_default();
}

/* Default react sequence for initial entry EntryToWaitForPlayRespToReplay */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay()
{
	/* Default react sequence for initial entry EntryToWaitForPlayRespToReplay */
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_default();
}

/* Default react sequence for initial entry  */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_default();
}

/* Default react sequence for initial entry PlayAfterStopResp */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp()
{
	/* Default react sequence for initial entry PlayAfterStopResp */
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default();
}

/* Default react sequence for initial entry  */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle_default();
}

/* Default react sequence for initial entry  */
void PmRingtoneHandlerSm::react_Main_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RingtoneHandler_default();
}

/* The reactions of exit MoveToIdle. */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle()
{
	/* The reactions of exit MoveToIdle. */
	effect_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_tr3();
}

/* The reactions of exit MoveToIdle. */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_MoveToIdle()
{
	/* The reactions of exit MoveToIdle. */
	effect_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_tr0();
}

/* The reactions of exit ToIdle. */
void PmRingtoneHandlerSm::react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle()
{
	/* The reactions of exit ToIdle. */
	effect_Main_region_RingtoneHandler_tr2();
}

sc_boolean PmRingtoneHandlerSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_react(const sc_boolean try_transition) {
	/* The reactions of state RingtoneHandler. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceSmHandler.SWITCH_TO_ACTIVE_raised)
		{ 
			exseq_Main_region_RingtoneHandler();
			ifaceAudioManagerRequest_OCB->requestRingtoneAudio();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler);
			}
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_default();
			react();
		}  else
		{
			if (ifaceUserAction.PAUSE_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler);
				}
				react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_Idle_react(const sc_boolean try_transition) {
	/* The reactions of state Idle. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.PLAY_RINGTONE_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
			ifaceAudioManagerRequest_OCB->requestRingtoneAudio();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_default();
			Main_region_RingtoneHandler_react(false);
		}  else
		{
			if (ifaceUserAction.WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_PlayAfterStopResp();
				Main_region_RingtoneHandler_react(false);
			}  else
			{
				if (ifaceUserAction.PAUSE_RINGTONE_raised)
				{ 
					exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
					enseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle_default();
				}  else
				{
					if (ifaceUserAction.WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE_raised)
					{ 
						exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
						enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_EntryToWaitForPlayRespToReplay();
						Main_region_RingtoneHandler_react(false);
					}  else
					{
						if (ifaceUserAction.WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE_raised)
						{ 
							exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
							enseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_default();
							Main_region_RingtoneHandler_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(const sc_boolean try_transition) {
	/* The reactions of state PlayRingtone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.STOP_RINGTONE_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_default();
			Main_region_RingtoneHandler_react(false);
		}  else
		{
			if ((ifaceSmHandler.MOVE_TO_IDLE_raised) || (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised))
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone);
				}
				react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle();
			}  else
			{
				if (ifaceUserAction.PAUSE_RINGTONE_raised)
				{ 
					exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone();
					ifaceAudioManagerRequest_OCB->pauseRingtone();
					if(ifaceTraceObserver != sc_null) {
						ifaceTraceObserver->stateEntered(PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone);
					}
					react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_default();
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
		}  else
		{
			if (ifaceUserAction.PLAY_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_default();
				Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
			}  else
			{
				if (ifaceUserAction.PAUSE_RINGTONE_raised)
				{ 
					exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
					react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStarted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
			ifaceSmHandler_OCB->sendPauseResponse((sc_string) "PAUSE_OK");
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_default();
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
		}  else
		{
			if (ifaceUserAction.PLAY_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
				ifaceAudioManagerRequest_OCB->pauseRingtone();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_default();
				Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.MUTE_RINGTONE_raised)
		{ 
			ifaceAudioManagerRequest_OCB->pauseRingtone();
		} 
		if (ifaceUserAction.UNMUTE_RINGTONE_raised)
		{ 
			ifaceSmHandler_OCB->sendPlayResponse((sc_string) "PLAY_ERROR");
		} 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused();
			ifaceSmHandler_OCB->sendPlayResponse((sc_string) "PLAY_OK");
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_default();
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.UNMUTE_RINGTONE_raised)
		{ 
			ifaceAudioManagerRequest_OCB->resumeRingtone();
		} 
		if (ifaceUserAction.MUTE_RINGTONE_raised)
		{ 
			ifaceSmHandler_OCB->sendPauseResponse((sc_string) "PAUSE_ERROR");
		} 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_react(const sc_boolean try_transition) {
	/* The reactions of state Replay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_default();
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
		}  else
		{
			if (ifaceUserAction.PAUSE_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
				react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			ifaceAudioManagerRequest_OCB->pauseRingtone();
		} 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayRespToReplay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
			ifaceAudioManagerRequest_OCB->pauseRingtone();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_default();
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
		}  else
		{
			if (ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_default();
				Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRingtoneChannelAcquisition. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.RINGTONE_CHANNEL_DENIED_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
			react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
		}  else
		{
			if (ifaceUserAction.STOP_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_default();
				Main_region_RingtoneHandler_react(false);
			}  else
			{
				if (ifaceAudioManagerResponse.RINGTONE_CHANNEL_GRANTED_raised)
				{ 
					exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
					enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_default();
					Main_region_RingtoneHandler_react(false);
				}  else
				{
					if (ifaceUserAction.PAUSE_RINGTONE_raised)
					{ 
						exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
						react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(const sc_boolean try_transition) {
	/* The reactions of state StoppingRingtone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.RINGTONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_default();
			Main_region_RingtoneHandler_react(false);
		}  else
		{
			if (ifaceUserAction.STOP_RINGTONE_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
				enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_default();
				Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(false);
			}  else
			{
				if (ifaceAudioManagerResponse.RINGTONE_CHANNEL_DENIED_raised)
				{ 
					exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
					react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_MoveToIdle();
				}  else
				{
					if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
					{ 
						exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
						ifaceAudioManagerRequest_OCB->requestRingtoneAudio();
						ifaceSmHandler_OCB->updateRingtoneStatus(RT_SM_PREPARING_CH);
						enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.PLAY_RINGTONE_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default();
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(false);
		}  else
		{
			if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
				react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_MoveToIdle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmRingtoneHandlerSm::Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStopAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.PLAY_RINGTONE_raised)
		{ 
			exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
			enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default();
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(false);
		}  else
		{
			if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
				react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_MoveToIdle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(try_transition);
	} 
	return did_transition;
}



